/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.linkchecker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.internal.MemoryConfigurationSource;
import org.xwiki.rendering.transformation.linkchecker.LinkCheckerTransformationConfiguration;

@Component
@Singleton
public class DefaultLinkCheckerTransformationConfiguration
implements LinkCheckerTransformationConfiguration,
Initializable {
    private static final String PREFIX = "rendering.transformation.linkchecker.";
    private static final long TIMEOUT = 3600000L;
    private Long checkTimeout;
    @Inject
    private ComponentManager componentManager;
    private ConfigurationSource configurationSource;

    public void initialize() throws InitializationException {
        try {
            this.configurationSource = (ConfigurationSource)this.componentManager.getInstance(ConfigurationSource.class);
        }
        catch (ComponentLookupException e) {
            this.configurationSource = new MemoryConfigurationSource();
        }
    }

    @Override
    public long getCheckTimeout() {
        long result = this.checkTimeout != null ? this.checkTimeout.longValue() : ((Long)this.configurationSource.getProperty("rendering.transformation.linkchecker.timeout", (Object)3600000L)).longValue();
        return result;
    }

    @Override
    public void setCheckTimeout(long checkTimeout) {
        this.checkTimeout = checkTimeout;
    }

    protected List<Pattern> getDefaultExcludedReferencePatterns() {
        return Collections.emptyList();
    }

    @Override
    public List<Pattern> getExcludedReferencePatterns() {
        List<Pattern> patterns;
        List patternsAsString = (List)this.configurationSource.getProperty("rendering.transformation.linkchecker.excludedReferencePatterns", List.class);
        if (patternsAsString.isEmpty()) {
            patterns = this.getDefaultExcludedReferencePatterns();
        } else {
            patterns = new ArrayList<Pattern>();
            for (String patternAsString : patternsAsString) {
                patterns.add(Pattern.compile(patternAsString));
            }
        }
        return patterns;
    }
}

