/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.linkchecker;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.internal.transformation.linkchecker.LinkCheckerThread;
import org.xwiki.rendering.internal.transformation.linkchecker.LinkQueueItem;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.transformation.AbstractTransformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.linkchecker.LinkContextDataProvider;

@Component
@Named(value="linkchecker")
@Singleton
public class LinkCheckerTransformation
extends AbstractTransformation
implements Initializable {
    static final int MAX_LINKS_IN_QUEUE = 10;
    @Inject
    private LinkCheckerThread checkerThread;
    @Inject
    private Provider<List<LinkContextDataProvider>> linkContextDataProvidersProvider;
    private Queue<LinkQueueItem> linkQueue = new ConcurrentLinkedQueue<LinkQueueItem>();

    public void initialize() throws InitializationException {
        this.checkerThread.setName("Link Checker Thread");
        this.checkerThread.startProcessing(this.getLinkQueue());
    }

    public void transform(Block source, TransformationContext context) throws TransformationException {
        if (this.getLinkQueue().size() < 10) {
            for (LinkBlock linkBlock : source.getBlocks((BlockMatcher)new ClassBlockMatcher(LinkBlock.class), Block.Axes.DESCENDANT)) {
                if (!linkBlock.getReference().getType().equals((Object)ResourceType.URL)) continue;
                String linkReference = linkBlock.getReference().getReference();
                String contentReference = this.extractSourceContentReference((Block)linkBlock);
                if (contentReference == null) {
                    contentReference = "default";
                }
                Map<String, Object> linkContextData = this.createLinkContextData(linkReference, contentReference);
                this.linkQueue.add(new LinkQueueItem(linkReference, contentReference, linkContextData));
            }
        }
    }

    public void stopLinkCheckerThread() throws InterruptedException {
        this.checkerThread.stopProcessing();
        this.checkerThread.join();
    }

    public Queue<LinkQueueItem> getLinkQueue() {
        return this.linkQueue;
    }

    private Map<String, Object> createLinkContextData(String linkReference, String contentReference) {
        LinkedHashMap<String, Object> linkContextData = null;
        for (LinkContextDataProvider linkContextDataProvider : (List)this.linkContextDataProvidersProvider.get()) {
            Map<String, Object> contextData = linkContextDataProvider.getContextData(linkReference, contentReference);
            if (linkContextData == null) {
                linkContextData = new LinkedHashMap<String, Object>(contextData.size());
            }
            linkContextData.putAll(contextData);
        }
        return linkContextData;
    }

    private String extractSourceContentReference(Block source) {
        String contentSource = null;
        MetaDataBlock metaDataBlock = (MetaDataBlock)source.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("source"), Block.Axes.ANCESTOR);
        if (metaDataBlock != null) {
            contentSource = (String)metaDataBlock.getMetaData().getMetaData("source");
        }
        return contentSource;
    }
}

