/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroIdFactory;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Singleton
public class DefaultMacroManager
extends AbstractLogEnabled
implements MacroManager {
    @Inject
    private MacroIdFactory macroIdFactory;
    @Inject
    private ComponentManager rootComponentManager;

    @Override
    public Set<MacroId> getMacroIds() throws MacroLookupException {
        return this.getMacroIds(null);
    }

    @Override
    public Set<MacroId> getMacroIds(Syntax syntax) throws MacroLookupException {
        Map allMacros;
        HashSet<MacroId> result = new HashSet<MacroId>();
        try {
            allMacros = this.getComponentManager().lookupMap(Macro.class);
        }
        catch (ComponentLookupException e) {
            throw new MacroLookupException("Failed to lookup Macros", e);
        }
        for (Map.Entry entry : allMacros.entrySet()) {
            MacroId macroId;
            try {
                macroId = this.macroIdFactory.createMacroId((String)entry.getKey());
            }
            catch (ParseException e) {
                this.getLogger().warn("Invalid Macro descriptor format for hint [" + (String)entry.getKey() + "]. The hint should contain either the macro name only or the macro name followed by " + "the syntax for which it is valid. In that case the macro name should be followed by a " + "\"/\" followed by the syntax name followed by another \"/\" followed by the syntax version. " + "For example \"html/xwiki/2.0\". This macro will not be available in the system.");
                continue;
            }
            if (syntax != null && macroId.getSyntax() != null && syntax != macroId.getSyntax()) continue;
            result.add(macroId);
        }
        return result;
    }

    @Override
    public Macro<?> getMacro(MacroId macroId) throws MacroLookupException {
        String macroHint = macroId.toString();
        try {
            return (Macro)this.getComponentManager().lookup(Macro.class, macroHint);
        }
        catch (ComponentLookupException ex1) {
            try {
                return (Macro)this.getComponentManager().lookup(Macro.class, macroId.getId());
            }
            catch (ComponentLookupException ex2) {
                throw new MacroLookupException(String.format("No macro [%s] could be found.", macroId.toString()));
            }
        }
    }

    @Override
    public boolean exists(MacroId macroId) {
        String macroHint = macroId.toString();
        boolean hasMacro = true;
        try {
            this.getComponentManager().lookup(Macro.class, macroHint);
        }
        catch (ComponentLookupException ex) {
            hasMacro = false;
        }
        return hasMacro;
    }

    private ComponentManager getComponentManager() {
        ComponentManager componentManagerToUse;
        try {
            componentManagerToUse = (ComponentManager)this.rootComponentManager.lookup(ComponentManager.class, "context");
        }
        catch (ComponentLookupException e) {
            componentManagerToUse = this.rootComponentManager;
        }
        return componentManagerToUse;
    }
}

