/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.macro.MacroCategoryManager;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.macro.MacroTransformationConfiguration;

@Component
@Singleton
public class DefaultMacroCategoryManager
implements MacroCategoryManager {
    @Inject
    private MacroTransformationConfiguration configuration;
    @Inject
    private MacroManager macroManager;

    @Override
    public Set<String> getMacroCategories() throws MacroLookupException {
        return this.getMacroCategories(null);
    }

    @Override
    public Set<String> getMacroCategories(final Syntax syntax) throws MacroLookupException {
        Set<String> categories = this.getMacroIdsByCategory(new MacroMatcher(){

            @Override
            public boolean match(MacroId macroId) {
                return syntax == null || macroId.getSyntax() == null || macroId.getSyntax() == syntax;
            }
        }).keySet();
        return Collections.unmodifiableSet(categories);
    }

    @Override
    public Set<MacroId> getMacroIds(String category) throws MacroLookupException {
        return this.getMacroIds(category, null);
    }

    @Override
    public Set<MacroId> getMacroIds(String category, final Syntax syntax) throws MacroLookupException {
        Set<MacroId> macros = this.getMacroIdsByCategory(new MacroMatcher(){

            @Override
            public boolean match(MacroId macroId) {
                return syntax == null || macroId.getSyntax() == null || macroId.getSyntax().equals((Object)syntax);
            }
        }).get(category);
        return null != macros ? Collections.unmodifiableSet(macros) : Collections.emptySet();
    }

    private Map<String, Set<MacroId>> getMacroIdsByCategory(MacroMatcher matcher) throws MacroLookupException {
        HashMap<String, Set<MacroId>> result = new HashMap<String, Set<MacroId>>();
        Set<MacroId> macroIds = this.macroManager.getMacroIds();
        Properties categories = this.configuration.getCategories();
        for (MacroId macroId : macroIds) {
            HashSet<MacroId> ids;
            if (!matcher.match(macroId)) continue;
            String category = categories.getProperty(macroId.toString());
            if (category == null) {
                category = this.macroManager.getMacro(macroId).getDescriptor().getDefaultCategory();
            }
            if ((ids = (HashSet<MacroId>)result.get(category)) == null) {
                ids = new HashSet<MacroId>();
            }
            ids.add(macroId);
            result.put(category, ids);
        }
        return result;
    }

    private static interface MacroMatcher {
        public boolean match(MacroId var1);
    }
}

