/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.macro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.BeanManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.internal.transformation.macro.MacroErrorManager;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.MacroNotFoundException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.AbstractTransformation;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;

@Component
@Named(value="macro")
@Singleton
public class MacroTransformation
extends AbstractTransformation {
    private int maxRecursions = 1000;
    @Inject
    private MacroManager macroManager;
    @Inject
    private BeanManager beanManager;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private Logger logger;
    private MacroErrorManager macroErrorManager = new MacroErrorManager();

    public int getPriority() {
        return 100;
    }

    public void transform(Block rootBlock, TransformationContext context) throws TransformationException {
        MacroTransformationContext macroContext = new MacroTransformationContext(context);
        macroContext.setTransformation((Transformation)this);
        int recursions = 0;
        List macroBlocks = rootBlock.getBlocks((BlockMatcher)new ClassBlockMatcher(MacroBlock.class), Block.Axes.DESCENDANT);
        while (!macroBlocks.isEmpty() && recursions < this.maxRecursions) {
            if (this.transformOnce(rootBlock, macroContext, context.getSyntax())) {
                ++recursions;
            }
            macroBlocks = rootBlock.getBlocks((BlockMatcher)new ClassBlockMatcher(MacroBlock.class), Block.Axes.DESCENDANT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transformOnce(Block rootBlock, MacroTransformationContext context, Syntax syntax) {
        List<Block> newBlocks;
        MacroHolder macroHolder = this.getHighestPriorityMacro(rootBlock, syntax);
        if (macroHolder == null) {
            return false;
        }
        boolean result = macroHolder.macroBlock.getParent() instanceof MacroMarkerBlock;
        try {
            if (macroHolder.macroBlock.isInline()) {
                context.setInline(true);
                if (!macroHolder.macro.supportsInlineMode()) {
                    this.macroErrorManager.generateError(macroHolder.macroBlock, "This is a standalone macro only and it cannot be used inline", "This macro generates standalone content. As a consequence you need to make sure to use a syntax that separates your macro from the content before and after it so that it's on a line by itself. For example in XWiki Syntax 2.0+ this means having 2 newline characters (a.k.a line breaks) separating your macro from the content before and after it.");
                    this.logger.debug("The [{}] macro doesn't support inline mode.", (Object)macroHolder.macroBlock.getId());
                    boolean bl = false;
                    return bl;
                }
            } else {
                context.setInline(false);
            }
            context.setCurrentMacroBlock(macroHolder.macroBlock);
            ((MutableRenderingContext)this.renderingContext).setCurrentBlock((Block)macroHolder.macroBlock);
            Object macroParameters = macroHolder.macro.getDescriptor().getParametersBeanClass().newInstance();
            try {
                this.beanManager.populate(macroParameters, macroHolder.macroBlock.getParameters());
            }
            catch (Throwable e) {
                this.macroErrorManager.generateError(macroHolder.macroBlock, String.format("Invalid macro parameters used for the \"%s\" macro", macroHolder.macroBlock.getId()), e);
                this.logger.debug("Invalid macro parameter for the [{}] macro. Internal error: [{}]", (Object)macroHolder.macroBlock.getId(), (Object)e.getMessage());
                boolean bl = false;
                ((MutableRenderingContext)this.renderingContext).setCurrentBlock(null);
                return bl;
            }
            newBlocks = macroHolder.macro.execute(macroParameters, macroHolder.macroBlock.getContent(), context);
        }
        catch (Throwable e) {
            this.macroErrorManager.generateError(macroHolder.macroBlock, String.format("Failed to execute the [%s] macro", macroHolder.macroBlock.getId()), e);
            this.logger.debug("Failed to execute the [{}] macro. Internal error [{}]", (Object)macroHolder.macroBlock.getId(), (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            ((MutableRenderingContext)this.renderingContext).setCurrentBlock(null);
        }
        Block resultBlock = this.wrapInMacroMarker(macroHolder.macroBlock, newBlocks);
        macroHolder.macroBlock.getParent().replaceChild(resultBlock, (Block)macroHolder.macroBlock);
        return result;
    }

    private MacroHolder getHighestPriorityMacro(Block rootBlock, Syntax syntax) {
        ArrayList<MacroHolder> macroHolders = new ArrayList<MacroHolder>();
        List macroBlocks = rootBlock.getBlocks((BlockMatcher)new ClassBlockMatcher(MacroBlock.class), Block.Axes.DESCENDANT);
        for (MacroBlock macroBlock : macroBlocks) {
            try {
                Macro<?> macro = this.macroManager.getMacro(new MacroId(macroBlock.getId(), syntax));
                macroHolders.add(new MacroHolder(macro, macroBlock));
            }
            catch (MacroNotFoundException e) {
                this.macroErrorManager.generateError(macroBlock, String.format("Unknown macro: %s", macroBlock.getId()), String.format("The \"%s\" macro is not in the list of registered macros. Verify the spelling or contact your administrator.", macroBlock.getId()));
                this.logger.debug("Failed to locate the [{}] macro. Ignoring it.", (Object)macroBlock.getId());
            }
            catch (MacroLookupException e) {
                this.macroErrorManager.generateError(macroBlock, String.format("Invalid macro: %s", macroBlock.getId()), e);
                this.logger.debug("Failed to instantiate the [{}] macro. Ignoring it.", (Object)macroBlock.getId());
            }
        }
        Collections.sort(macroHolders);
        return macroHolders.size() > 0 ? (MacroHolder)macroHolders.get(0) : null;
    }

    private Block wrapInMacroMarker(MacroBlock macroBlockToWrap, List<Block> newBlocks) {
        return new MacroMarkerBlock(macroBlockToWrap.getId(), macroBlockToWrap.getParameters(), macroBlockToWrap.getContent(), newBlocks, macroBlockToWrap.isInline());
    }

    public void setMaxRecursions(int maxRecursions) {
        this.maxRecursions = maxRecursions;
    }

    private class MacroHolder
    implements Comparable<MacroHolder> {
        Macro<?> macro;
        MacroBlock macroBlock;

        public MacroHolder(Macro<?> macro, MacroBlock macroBlock) {
            this.macro = macro;
            this.macroBlock = macroBlock;
        }

        @Override
        public int compareTo(MacroHolder holder) {
            return this.macro.compareTo(holder.macro);
        }
    }
}

