/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xhtml.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xwiki.rendering.wikimodel.WikiPageUtil;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.impl.WikiScannerContext;
import org.xwiki.rendering.wikimodel.xhtml.XhtmlCharacter;
import org.xwiki.rendering.wikimodel.xhtml.XhtmlCharacterType;
import org.xwiki.rendering.wikimodel.xhtml.handler.BoldTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.BreakTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.CommentHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.DefinitionDescriptionTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.DefinitionTermTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.DivisionTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.HeaderTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.HorizontalLineTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.ImgTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.ItalicTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.ListItemTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.ListTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.ParagraphTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.PreserveTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.QuoteTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.ReferenceTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.SpanTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.StrikedOutTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.SubScriptTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.SuperScriptTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.TableDataTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.TableRowTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.TableTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.TagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.TeletypeTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.UnderlineTagHandler;

public class XhtmlHandler
extends DefaultHandler
implements LexicalHandler {
    protected String fDocumentSectionUri;
    protected String fDocumentUri;
    protected String fDocumentWikiProperties;
    TagStack fStack;

    public XhtmlHandler(WikiScannerContext context, Map<String, TagHandler> extraHandlers) {
        this(context, extraHandlers, new CommentHandler());
    }

    public XhtmlHandler(WikiScannerContext context, Map<String, TagHandler> extraHandlers, CommentHandler commentHandler) {
        this.fStack = new TagStack(context);
        this.fStack.setCommentHandler(commentHandler);
        this.fStack.add("p", new ParagraphTagHandler());
        this.fStack.add("table", new TableTagHandler());
        this.fStack.add("tr", new TableRowTagHandler());
        TagHandler handler = new TableDataTagHandler();
        this.fStack.add("td", handler);
        this.fStack.add("th", handler);
        handler = new ListTagHandler();
        this.fStack.add("ul", handler);
        this.fStack.add("ol", handler);
        this.fStack.add("dl", handler);
        handler = new ListItemTagHandler();
        this.fStack.add("li", handler);
        this.fStack.add("dt", new DefinitionTermTagHandler());
        this.fStack.add("dd", new DefinitionDescriptionTagHandler());
        handler = new HeaderTagHandler();
        this.fStack.add("h1", handler);
        this.fStack.add("h2", handler);
        this.fStack.add("h3", handler);
        this.fStack.add("h4", handler);
        this.fStack.add("h5", handler);
        this.fStack.add("h6", handler);
        this.fStack.add("hr", new HorizontalLineTagHandler());
        this.fStack.add("pre", new PreserveTagHandler());
        handler = new ReferenceTagHandler();
        this.fStack.add("a", handler);
        handler = new ImgTagHandler();
        this.fStack.add("img", handler);
        handler = new BoldTagHandler();
        this.fStack.add("strong", handler);
        this.fStack.add("b", handler);
        handler = new UnderlineTagHandler();
        this.fStack.add("ins", handler);
        this.fStack.add("u", handler);
        handler = new StrikedOutTagHandler();
        this.fStack.add("del", handler);
        this.fStack.add("strike", handler);
        this.fStack.add("s", handler);
        handler = new ItalicTagHandler();
        this.fStack.add("em", handler);
        this.fStack.add("i", handler);
        this.fStack.add("sup", new SuperScriptTagHandler());
        this.fStack.add("sub", new SubScriptTagHandler());
        this.fStack.add("tt", new TeletypeTagHandler());
        this.fStack.add("br", new BreakTagHandler());
        this.fStack.add("div", new DivisionTagHandler());
        handler = new QuoteTagHandler();
        this.fStack.add("blockquote", handler);
        this.fStack.add("quote", handler);
        this.fStack.add("span", new SpanTagHandler());
        this.fStack.addAll(extraHandlers);
        for (TagHandler tagElementHandler : this.fStack.fMap.values()) {
            tagElementHandler.initialize(this.fStack);
        }
    }

    @Override
    public void characters(char[] array, int start, int length) throws SAXException {
        this.fStack.onCharacters(new String(array, start, length));
    }

    @Override
    public void endDocument() throws SAXException {
        TagHandler.sendEmptyLines(this.fStack.fPeek);
        this.fStack.endElement();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.fStack.endElement();
    }

    protected String getHref(Attributes attributes) {
        String value = attributes.getValue("HREF");
        if (value == null) {
            value = attributes.getValue("href");
        }
        if (value == null) {
            value = attributes.getValue("src");
        }
        if (value == null) {
            value = attributes.getValue("SRC");
        }
        return value;
    }

    @Override
    public void startDocument() throws SAXException {
        this.fStack.beginElement(null, null);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.fStack.beginElement(this.getLocalName(uri, localName, qName, false), this.getParameters(attributes));
    }

    @Override
    public void comment(char[] array, int start, int length) throws SAXException {
        this.fStack.onComment(array, start, length);
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
    }

    private String getLocalName(String uri, String localName, String name, boolean upperCase) {
        String result = localName != null && !"".equals(localName) ? localName : name;
        return upperCase ? result.toUpperCase() : result;
    }

    private WikiParameters getParameters(Attributes attributes) {
        ArrayList<WikiParameter> params = new ArrayList<WikiParameter>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String key = this.getLocalName(attributes.getURI(i), attributes.getQName(i), attributes.getLocalName(i), false);
            String value = attributes.getValue(i);
            WikiParameter param = new WikiParameter(key, value);
            if (attributes instanceof Attributes2) {
                Attributes2 attributes2 = (Attributes2)attributes;
                if (!attributes2.isSpecified(i)) continue;
                params.add(param);
                continue;
            }
            params.add(param);
        }
        return new WikiParameters(params);
    }

    public static class TagStack {
        private Map<String, TagHandler> fMap = new HashMap<String, TagHandler>();
        private CommentHandler fCommentHandler;
        private Deque<Map<String, Object>> fStackParameters = new ArrayDeque<Map<String, Object>>();
        private TagContext fPeek;
        private Deque<WikiScannerContext> fScannerContext = new ArrayDeque<WikiScannerContext>();

        public void add(String tag, TagHandler handler) {
            this.fMap.put(tag, handler);
        }

        public void addAll(Map<String, TagHandler> handlers) {
            this.fMap.putAll(handlers);
        }

        public void setCommentHandler(CommentHandler handler) {
            this.fCommentHandler = handler;
        }

        public TagStack(WikiScannerContext context) {
            this.pushStackParameters();
            this.fScannerContext.push(context);
            this.fCommentHandler = new CommentHandler();
        }

        public void beginElement(String name, WikiParameters params) {
            this.fPeek = new TagContext(this.fPeek, name, params, this);
            name = this.fPeek.getName();
            TagHandler handler = this.fMap.get(name);
            boolean ignoreElements = (Boolean)this.getStackParameter("ignoreElements");
            if (!ignoreElements) {
                this.fPeek.beginElement(handler);
            }
        }

        public void endElement() {
            boolean ignoreElements = (Boolean)this.getStackParameter("ignoreElements");
            if (!ignoreElements) {
                this.fPeek.endElement();
            }
            this.fPeek = this.fPeek.fParent;
        }

        private XhtmlCharacterType getCharacterType(char ch) {
            XhtmlCharacterType type = XhtmlCharacterType.CHARACTER;
            switch (ch) {
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '_': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    type = XhtmlCharacterType.SPECIAL_SYMBOL;
                    break;
                }
                case '\t': 
                case ' ': 
                case '\u00a0': {
                    type = XhtmlCharacterType.SPACE;
                    break;
                }
                case '\n': 
                case '\r': {
                    type = XhtmlCharacterType.NEW_LINE;
                    break;
                }
            }
            return type;
        }

        public WikiScannerContext getScannerContext() {
            return this.fScannerContext.isEmpty() ? null : this.fScannerContext.peek();
        }

        public void setScannerContext(WikiScannerContext context) {
            if (!this.fScannerContext.isEmpty()) {
                this.fScannerContext.pop();
            }
            this.fScannerContext.push(context);
        }

        public void pushScannerContext(WikiScannerContext context) {
            this.fScannerContext.push(context);
        }

        public WikiScannerContext popScannerContext() {
            return this.fScannerContext.pop();
        }

        private void flushStack(Queue<XhtmlCharacter> stack) {
            block6: while (!stack.isEmpty()) {
                XhtmlCharacter character = stack.poll();
                switch (character.getType()) {
                    case ESCAPED: {
                        this.getScannerContext().onEscape("" + character.getCharacter());
                        continue block6;
                    }
                    case SPECIAL_SYMBOL: {
                        this.getScannerContext().onSpecialSymbol("" + character.getCharacter());
                        continue block6;
                    }
                    case NEW_LINE: {
                        this.getScannerContext().onLineBreak();
                        continue block6;
                    }
                    case SPACE: {
                        StringBuilder spaceBuffer = new StringBuilder(" ");
                        while (!stack.isEmpty() && stack.element().getType() == XhtmlCharacterType.SPACE) {
                            stack.poll();
                            spaceBuffer.append(' ');
                        }
                        this.getScannerContext().onSpace(spaceBuffer.toString());
                        continue block6;
                    }
                }
                StringBuilder charBuffer = new StringBuilder();
                charBuffer.append(character.getCharacter());
                while (!stack.isEmpty() && stack.element().getType() == XhtmlCharacterType.CHARACTER) {
                    charBuffer.append(stack.poll().getCharacter());
                }
                this.getScannerContext().onWord(WikiPageUtil.escapeXmlString(charBuffer.toString()));
            }
        }

        public void onCharacters(String content) {
            if (!this.fPeek.isContentContainer()) {
                return;
            }
            boolean ignoreElements = (Boolean)this.getStackParameter("ignoreElements");
            if (ignoreElements) {
                return;
            }
            if (!this.fPeek.appendContent(content)) {
                ArrayDeque<XhtmlCharacter> stack = new ArrayDeque<XhtmlCharacter>();
                for (int i = 0; i < content.length(); ++i) {
                    char c = content.charAt(i);
                    stack.offer(new XhtmlCharacter(c, this.getCharacterType(c)));
                }
                this.flushStack(stack);
            }
        }

        public void onComment(char[] array, int start, int length) {
            this.fCommentHandler.onComment(new String(array, start, length), this);
        }

        public void pushStackParameters() {
            this.fStackParameters.push(new HashMap());
            this.setStackParameter("ignoreElements", false);
            this.setStackParameter("emptyLinesCount", 0);
            this.setStackParameter("listStyles", new StringBuffer());
            this.setStackParameter("quoteDepth", new Integer(0));
            this.setStackParameter("insideBlockElement", new ArrayDeque());
            for (TagHandler tagElementHandler : this.fMap.values()) {
                tagElementHandler.initialize(this);
            }
        }

        public void popStackParameters() {
            this.fStackParameters.pop();
        }

        private Map<String, Object> getStackParameters() {
            return this.fStackParameters.peek();
        }

        public void setStackParameter(String name, Object data) {
            Deque set = (Deque)this.getStackParameters().get(name);
            if (set != null && !set.isEmpty()) {
                set.pop();
            }
            this.pushStackParameter(name, data);
        }

        public Object getStackParameter(String name) {
            Deque set = (Deque)this.getStackParameters().get(name);
            return set == null ? null : set.peek();
        }

        @Deprecated
        public Object getStackParameter(String name, int index) {
            Deque set = (Deque)this.getStackParameters().get(name);
            if (set == null || set.size() <= index) {
                return null;
            }
            return set.toArray()[set.size() - index - 1];
        }

        public Iterator<Object> getStackParameterIterator(String name) {
            Deque set = (Deque)this.getStackParameters().get(name);
            return set == null ? null : set.descendingIterator();
        }

        public void pushStackParameter(String name, Object data) {
            LinkedList<Object> set = (LinkedList<Object>)this.getStackParameters().get(name);
            if (set == null) {
                set = new LinkedList<Object>();
                this.getStackParameters().put(name, set);
            }
            set.push(data);
        }

        public Object popStackParameter(String name) {
            return ((Deque)this.getStackParameters().get(name)).pop();
        }

        public class TagContext {
            private final WikiParameters fParameters;
            private String fName;
            private StringBuffer fContent;
            public TagHandler fHandler;
            private final TagContext fParent;
            TagStack fTagStack;

            public TagContext(TagContext parent, String name, WikiParameters params, TagStack tagStack2) {
                this.fName = name;
                this.fParent = parent;
                this.fParameters = params;
                this.fTagStack = tagStack2;
            }

            public boolean appendContent(String content) {
                if (this.fHandler == null || !this.fHandler.isAccumulateContent()) {
                    return false;
                }
                if (this.fContent == null) {
                    this.fContent = new StringBuffer();
                }
                this.fContent.append(content);
                return true;
            }

            public void beginElement(TagHandler handler) {
                if (this.fParent == null) {
                    this.getScannerContext().beginDocument();
                }
                this.fHandler = handler;
                if (this.fHandler != null) {
                    this.fHandler.beginElement(this);
                }
            }

            public void endElement() {
                if (this.fHandler != null) {
                    this.fHandler.endElement(this);
                }
                if (this.fParent == null) {
                    this.getScannerContext().endDocument();
                }
            }

            public String getContent() {
                return this.fContent != null ? WikiPageUtil.escapeXmlString(this.fContent.toString()) : "";
            }

            public String getName() {
                return this.fName;
            }

            public WikiParameters getParams() {
                return this.fParameters;
            }

            public TagContext getParent() {
                return this.fParent;
            }

            public WikiScannerContext getScannerContext() {
                return TagStack.this.fScannerContext.isEmpty() ? null : (WikiScannerContext)TagStack.this.fScannerContext.peek();
            }

            public TagStack getTagStack() {
                return this.fTagStack;
            }

            public boolean isContentContainer() {
                return this.fHandler == null || this.fHandler.isContentContainer();
            }

            public boolean isTag(String string) {
                return string.equals(this.fName.toLowerCase());
            }
        }
    }
}

