/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xwiki.xwiki20;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Stack;
import java.util.logging.Logger;
import org.xwiki.rendering.wikimodel.IWemConstants;
import org.xwiki.rendering.wikimodel.IWikiPrinter;
import org.xwiki.rendering.wikimodel.PrintTextListener;
import org.xwiki.rendering.wikimodel.ReferenceHandler;
import org.xwiki.rendering.wikimodel.WikiFormat;
import org.xwiki.rendering.wikimodel.WikiPageUtil;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;

public class XWikiSerializer2
extends PrintTextListener {
    private static final String[] HEADERS = new String[]{"", "=", "==", "===", "====", "=====", "======"};
    private Deque<ListOrdering> listOrdering = new ArrayDeque<ListOrdering>();
    private Stack<Table> tables = new Stack();
    private boolean listItemWritten = false;
    private boolean firstTableRow = false;
    private boolean withinTableCell = false;
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());

    public XWikiSerializer2(IWikiPrinter printer) {
        super(printer);
    }

    @Override
    public void beginHeader(int headerLevel, WikiParameters params) {
        this.println();
        this.print(HEADERS[headerLevel] + " ");
    }

    @Override
    public void endHeader(int headerLevel, WikiParameters params) {
        this.print(" " + HEADERS[headerLevel]);
        this.println();
    }

    @Override
    public void beginList(WikiParameters params, boolean ordered) {
        if (ordered) {
            this.listOrdering.push(ListOrdering.ORDERED);
        } else {
            this.listOrdering.push(ListOrdering.UNORDERED);
        }
        if (this.listItemWritten) {
            this.println();
        }
    }

    @Override
    public void endList(WikiParameters params, boolean ordered) {
        this.listOrdering.pop();
        this.listItemWritten = false;
    }

    @Override
    public void beginListItem() {
        ListOrdering[] orders = this.listOrdering.toArray(new ListOrdering[this.listOrdering.size()]);
        StringBuilder sb = new StringBuilder();
        boolean isordered = false;
        for (int i = 0; i < orders.length; ++i) {
            if (orders[i] == ListOrdering.ORDERED) {
                sb.append("1");
                isordered = true;
                continue;
            }
            sb.append("*");
        }
        if (isordered) {
            sb.append(".");
        }
        sb.append(" ");
        this.print(sb.toString());
        this.listItemWritten = true;
    }

    @Override
    public void endListItem() {
        if (this.listItemWritten) {
            this.println();
        }
    }

    @Override
    public void onImage(String ref) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public void onImage(WikiReference ref) {
        WikiParameters params = ref.getParameters();
        WikiParameter format = params.getParameter("format");
        if (format != null && "thumb".equals(format.getValue())) {
            this.onImageThumbnail(ref);
        } else {
            this.print("[[image:");
            String link = ref.getLink();
            int dotidx = link.indexOf(58);
            if (dotidx > 0) {
                link = link.substring(dotidx + 1);
            }
            link = XWikiSerializer2.clearName(link);
            this.print(link);
            if (ref.getLabel() != null) {
                params = params.addParameter("title", ref.getLabel());
            }
            if (params != null && params.getSize() > 0) {
                this.print("||");
                int len = params.getSize();
                for (int i = 0; i < len; ++i) {
                    this.print(" ");
                    WikiParameter param = params.getParameter(i);
                    String val = WikiPageUtil.escapeXmlAttribute(param.getValue());
                    this.print(param.getKey() + "=\"" + val + "\"");
                }
            }
            this.print("]]");
        }
    }

    protected void onImageThumbnail(WikiReference ref) {
        WikiParameters params = ref.getParameters();
        WikiParameter oldstyle = params.getParameter("style");
        if (oldstyle != null) {
            params.remove("style");
            params = params.addParameter("style", oldstyle.getValue() + ";" + "float: right; width:" + this.getImageThumbwidth());
        } else {
            params = params.addParameter("style", "float: right; width:" + this.getImageThumbwidth());
        }
        params = params.remove("format");
        WikiReference newimgref = new WikiReference(ref.getLink(), ref.getLabel(), params);
        this.onImage(newimgref);
    }

    @Override
    public void onVerbatimBlock(String str, WikiParameters params) {
        this.print("{{code language=none}}");
        this.print(str);
        this.print("{{/code}}");
    }

    @Override
    public void onVerbatimInline(String str, WikiParameters params) {
        this.println("{{code language=none}}");
        this.println(str);
        this.println("{{/code}}");
    }

    @Override
    public void onTableCaption(String str) {
        this.tables.peek().setCaption(str);
    }

    @Override
    public void beginTable(WikiParameters params) {
        Table t = new Table();
        if (params != null && params.getSize() > 0) {
            t.appendText("(% style=\"");
            for (WikiParameter param : params) {
                t.appendText(param.getKey() + ":" + param.getValue() + ";");
            }
            t.appendText("\" %)");
            t.appendText(this.getEol());
        }
        this.tables.push(t);
        this.firstTableRow = true;
    }

    @Override
    public void endTable(WikiParameters params) {
        Table table = this.tables.pop();
        if (table.getCaption() != null) {
            this.print("**");
            this.print(table.getCaption());
            this.print("**");
            this.println();
        }
        this.println(table.getText());
    }

    @Override
    public void beginTableCell(boolean tableHead, WikiParameters params) {
        Table t = this.tables.peek();
        if (this.firstTableRow) {
            t.appendText("|= ");
        } else {
            t.appendText("| ");
        }
        this.withinTableCell = true;
    }

    @Override
    public void endTableCell(boolean tableHead, WikiParameters params) {
        Table t = this.tables.peek();
        t.appendText(" ");
        this.withinTableCell = false;
    }

    @Override
    public void beginTableRow(WikiParameters params) {
    }

    @Override
    public void endTableRow(WikiParameters params) {
        Table t = this.tables.peek();
        t.appendText(this.getEol());
        this.firstTableRow = false;
    }

    @Override
    public void beginFormat(WikiFormat format) {
        if (format.hasStyle(IWemConstants.STRONG)) {
            this.print("**");
        } else if (format.hasStyle(IWemConstants.EM)) {
            this.print("//");
        } else if (format.hasStyle(IWemConstants.MONO)) {
            this.print("##");
        } else if (format.hasStyle(IWemConstants.TT)) {
            this.print("##");
        } else {
            super.beginFormat(format);
        }
    }

    @Override
    public void endFormat(WikiFormat format) {
        if (format.hasStyle(IWemConstants.TT)) {
            this.print("##");
        } else if (format.hasStyle(IWemConstants.MONO)) {
            this.print("##");
        } else if (format.hasStyle(IWemConstants.EM)) {
            this.print("//");
        } else if (format.hasStyle(IWemConstants.STRONG)) {
            this.print("**");
        } else {
            super.beginFormat(format);
        }
    }

    @Override
    public void endParagraph(WikiParameters params) {
        this.println();
        this.println();
    }

    @Override
    protected void endBlock() {
        this.println();
    }

    protected String getEol() {
        return "\n";
    }

    @Override
    public void onLineBreak() {
        this.print("\\\\");
    }

    @Override
    public void onNewLine() {
        super.onNewLine();
    }

    @Override
    public void onSpecialSymbol(String str) {
        if (this.withinTableCell && "|".equals(str)) {
            this.print("~");
        }
        this.print(str);
    }

    @Override
    public void beginDefinitionTerm() {
        this.print("; ");
    }

    @Override
    public void endDefinitionTerm() {
        this.println();
    }

    @Override
    public void beginDefinitionDescription() {
        this.print(": ");
    }

    @Override
    public void endDefinitionDescription() {
        this.println();
    }

    protected String getImageThumbwidth() {
        return "200px";
    }

    @Override
    protected void print(String str) {
        if (!this.tables.isEmpty()) {
            this.tables.peek().appendText(str);
        } else {
            super.print(str);
        }
    }

    @Override
    protected void println() {
        if (!this.tables.isEmpty()) {
            this.tables.peek().appendText(this.getEol());
        } else {
            super.println();
        }
    }

    @Override
    protected void println(String str) {
        if (!this.tables.isEmpty()) {
            this.tables.peek().appendText(str + this.getEol());
        } else {
            super.println(str);
        }
    }

    @Override
    protected ReferenceHandler newReferenceHandler() {
        return new XWiki2ReferenzeHandler();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public static final String clearName(String name, boolean stripDots, boolean ascii) {
        String temp = name;
        temp = temp.replaceAll("[\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u0100\u0102\u0104\u01cd\u01de\u01e0\u01fa\u0200\u0202\u0226]", "A");
        temp = temp.replaceAll("[\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u0101\u0103\u0105\u01ce\u01df\u01e1\u01fb\u0201\u0203\u0227]", "a");
        temp = temp.replaceAll("[\u00c6\u01e2\u01fc]", "AE");
        temp = temp.replaceAll("[\u00e6\u01e3\u01fd]", "ae");
        temp = temp.replaceAll("[\u008c\u0152]", "OE");
        temp = temp.replaceAll("[\u009c\u0153]", "oe");
        temp = temp.replaceAll("[\u00c7\u0106\u0108\u010a\u010c]", "C");
        temp = temp.replaceAll("[\u00e7\u0107\u0109\u010b\u010d]", "c");
        temp = temp.replaceAll("[\u00d0\u010e\u0110]", "D");
        temp = temp.replaceAll("[\u00f0\u010f\u0111]", "d");
        temp = temp.replaceAll("[\u00c8\u00c9\u00ca\u00cb\u0112\u0114\u0116\u0118\u011a\u0204\u0206\u0228]", "E");
        temp = temp.replaceAll("[\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011b\u01dd\u0205\u0207\u0229]", "e");
        temp = temp.replaceAll("[\u011c\u011e\u0120\u0122\u01e4\u01e6\u01f4]", "G");
        temp = temp.replaceAll("[\u011d\u011f\u0121\u0123\u01e5\u01e7\u01f5]", "g");
        temp = temp.replaceAll("[\u0124\u0126\u021e]", "H");
        temp = temp.replaceAll("[\u0125\u0127\u021f]", "h");
        temp = temp.replaceAll("[\u00cc\u00cd\u00ce\u00cf\u0128\u012a\u012c\u012e\u0130\u01cf\u0208\u020a]", "I");
        temp = temp.replaceAll("[\u00ec\u00ed\u00ee\u00ef\u0129\u012b\u012d\u012f\u0131\u01d0\u0209\u020b]", "i");
        temp = temp.replaceAll("[\u0132]", "IJ");
        temp = temp.replaceAll("[\u0133]", "ij");
        temp = temp.replaceAll("[\u0134]", "J");
        temp = temp.replaceAll("[\u0135]", "j");
        temp = temp.replaceAll("[\u0136\u01e8]", "K");
        temp = temp.replaceAll("[\u0137\u0138\u01e9]", "k");
        temp = temp.replaceAll("[\u0139\u013b\u013d\u013f\u0141]", "L");
        temp = temp.replaceAll("[\u013a\u013c\u013e\u0140\u0142\u0234]", "l");
        temp = temp.replaceAll("[\u00d1\u0143\u0145\u0147\u014a\u01f8]", "N");
        temp = temp.replaceAll("[\u00f1\u0144\u0146\u0148\u0149\u014b\u01f9\u0235]", "n");
        temp = temp.replaceAll("[\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u014c\u014e\u0150\u01d1\u01ea\u01ec\u01fe\u020c\u020e\u022a\u022c\u022e\u0230]", "O");
        temp = temp.replaceAll("[\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u014f\u0151\u01d2\u01eb\u01ed\u01ff\u020d\u020f\u022b\u022d\u022f\u0231]", "o");
        temp = temp.replaceAll("[\u0156\u0158\u0210\u0212]", "R");
        temp = temp.replaceAll("[\u0157\u0159\u0211\u0213]", "r");
        temp = temp.replaceAll("[\u015a\u015c\u015e\u0160\u0218]", "S");
        temp = temp.replaceAll("[\u015b\u015d\u015f\u0161\u0219]", "s");
        temp = temp.replaceAll("[\u00de\u0162\u0164\u0166\u021a]", "T");
        temp = temp.replaceAll("[\u00fe\u0163\u0165\u0167\u021b\u0236]", "t");
        temp = temp.replaceAll("[\u00d9\u00da\u00db\u00dc\u0168\u016a\u016c\u016e\u0170\u0172\u01d3\u01d5\u01d7\u01d9\u01db\u0214\u0216]", "U");
        temp = temp.replaceAll("[\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u0171\u0173\u01d4\u01d6\u01d8\u01da\u01dc\u0215\u0217]", "u");
        temp = temp.replaceAll("[\u0174]", "W");
        temp = temp.replaceAll("[\u0175]", "w");
        temp = temp.replaceAll("[\u00dd\u0176\u0178\u0232]", "Y");
        temp = temp.replaceAll("[\u00fd\u00ff\u0177\u0233]", "y");
        temp = temp.replaceAll("[\u0179\u017b\u017d]", "Z");
        temp = temp.replaceAll("[\u017a\u017c\u017e]", "z");
        temp = temp.replaceAll("[\u00df]", "SS");
        name = temp = temp.replaceAll("[_':,;\\\\/]", " ");
        name = name.replaceAll("\\s+", "");
        name = name.replaceAll("[\\(\\)]", " ");
        if (stripDots) {
            name = name.replaceAll("[\\.]", "");
        }
        if (ascii) {
            name = name.replaceAll("[^a-zA-Z0-9\\-_\\.]", "");
        }
        if (name.length() > 250) {
            name = name.substring(0, 250);
        }
        return name;
    }

    public static final String clearName(String name) {
        boolean stripDots = false;
        boolean ascii = true;
        return XWikiSerializer2.clearName(name, stripDots, ascii);
    }

    private static class Table {
        private StringBuilder text = new StringBuilder();
        private String caption;

        private Table() {
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }

        public StringBuilder appendText(CharSequence s) {
            return this.text.append(s);
        }

        public String getText() {
            return this.text.toString();
        }

        public String getCaption() {
            return this.caption;
        }
    }

    private class XWiki2ReferenzeHandler
    extends ReferenceHandler {
        XWiki2ReferenzeHandler() {
            this(false, false);
        }

        protected XWiki2ReferenzeHandler(boolean supportImage, boolean supportDownload) {
            super(supportImage, supportDownload);
        }

        @Override
        protected void handleImage(String ref, String label, WikiParameters params) {
            this.handleReference("image:" + ref, label, params);
        }

        @Override
        protected void handleReference(String ref, String label, WikiParameters params) {
            XWikiSerializer2.this.print("[[");
            if (label != null) {
                XWikiSerializer2.this.print(label + ">>");
            }
            XWikiSerializer2.this.print(ref);
            XWikiSerializer2.this.print("]]");
        }
    }

    private static enum ListOrdering {
        ORDERED,
        UNORDERED;

    }
}

