/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xml.internal.serializer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.apache.commons.lang3.ObjectUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.properties.ConverterManager;
import org.xwiki.rendering.listener.descriptor.ListenerDescriptor;
import org.xwiki.rendering.listener.descriptor.ListenerElement;
import org.xwiki.rendering.xml.internal.XMLConfiguration;
import org.xwiki.rendering.xml.internal.XMLUtils;
import org.xwiki.rendering.xml.internal.parameter.ParameterManager;

@Component
@Singleton
public class DefaultXMLSerializer
implements InvocationHandler {
    private static final Pattern VALID_ELEMENTNAME = Pattern.compile("[A-Za-z][A-Za-z0-9:_.-]*");
    private ContentHandler contentHandler;
    private ParameterManager parameterManager;
    private ListenerDescriptor descriptor;
    private ConverterManager converter;
    private XMLConfiguration configuration;

    public DefaultXMLSerializer(ContentHandler contentHandler, ParameterManager parameterManager, ListenerDescriptor descriptor, ConverterManager converter, XMLConfiguration configuration) {
        this.contentHandler = contentHandler;
        this.parameterManager = parameterManager;
        this.descriptor = descriptor;
        this.converter = converter;
        this.configuration = configuration != null ? configuration : new XMLConfiguration();
    }

    private boolean isValidBlockElementName(String blockName) {
        return VALID_ELEMENTNAME.matcher(blockName).matches() && !this.configuration.getElementParameter().equals(blockName);
    }

    private String getBlockName(String eventName, String prefix) {
        String blockName = eventName.substring(prefix.length());
        blockName = Character.toLowerCase(blockName.charAt(0)) + blockName.substring(1);
        return blockName;
    }

    private void addInlineParameters(AttributesImpl attributes, List<Object> parameters, ListenerElement element) {
        for (int i = 0; i < parameters.size(); ++i) {
            Object parameter = parameters.get(i);
            if (parameter == null) continue;
            Type type = (Type)element.getParameters().get(i);
            Class typeClass = ReflectionUtils.getTypeClass((Type)type);
            if (XMLUtils.isSimpleType(typeClass)) {
                attributes.addAttribute(null, null, this.configuration.getElementParameter() + i, null, (String)this.converter.convert(String.class, parameter));
                parameters.set(i, null);
                continue;
            }
            if (!ObjectUtils.equals((Object)XMLUtils.defaultValue(typeClass), (Object)parameter)) continue;
            attributes.addAttribute(null, null, this.configuration.getElementParameter() + i, null, "");
            parameters.set(i, null);
        }
    }

    private AttributesImpl createStartAttributes(String blockName, List<Object> parameters) {
        AttributesImpl attributes = new AttributesImpl();
        if (!this.isValidBlockElementName(blockName)) {
            attributes.addAttribute(null, null, this.configuration.getAttributeBlockName(), null, blockName);
        }
        if (parameters != null) {
            ListenerElement element = (ListenerElement)this.descriptor.getElements().get(blockName.toLowerCase());
            this.addInlineParameters(attributes, parameters, element);
        }
        return attributes;
    }

    private void removeDefaultParameters(List<Object> parameters, ListenerElement descriptor) {
        if (parameters != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                Object value = parameters.get(i);
                if (value == null || this.shouldPrintParameter(value, i, descriptor)) continue;
                parameters.set(i, null);
            }
        }
    }

    private void beginEvent(String eventName, Object[] parameters) {
        String blockName = this.getBlockName(eventName, "begin");
        ListenerElement element = (ListenerElement)this.descriptor.getElements().get(blockName.toLowerCase());
        List<Object> elementParameters = parameters != null ? Arrays.asList(parameters) : null;
        this.removeDefaultParameters(elementParameters, element);
        AttributesImpl attributes = this.createStartAttributes(blockName, elementParameters);
        String elementName = this.isValidBlockElementName(blockName) ? blockName : this.configuration.getElementBlock();
        this.startElement(elementName, attributes);
        this.printParameters(elementParameters, element);
    }

    private void endEvent(String eventName) {
        String blockName = this.getBlockName(eventName, "end");
        if (this.isValidBlockElementName(blockName)) {
            this.endElement(blockName);
        } else {
            this.endElement(this.configuration.getElementBlock());
        }
    }

    private void onEvent(String eventName, Object[] parameters) {
        String blockName = this.getBlockName(eventName, "on");
        ListenerElement element = (ListenerElement)this.descriptor.getElements().get(blockName.toLowerCase());
        List<Object> elementParameters = parameters != null ? Arrays.asList(parameters) : null;
        this.removeDefaultParameters(elementParameters, element);
        AttributesImpl attributes = elementParameters != null && elementParameters.size() > 1 ? this.createStartAttributes(blockName, Arrays.asList(parameters)) : new AttributesImpl();
        String elementName = this.isValidBlockElementName(blockName) ? blockName : this.configuration.getElementBlock();
        this.startElement(elementName, attributes);
        if (parameters != null && parameters.length == 1 && XMLUtils.isSimpleType((Type)element.getParameters().get(0))) {
            String value = parameters[0].toString();
            try {
                this.contentHandler.characters(value.toCharArray(), 0, value.length());
            }
            catch (SAXException e) {
                throw new RuntimeException("Failed to send sax event", e);
            }
        } else {
            this.printParameters(elementParameters, element);
        }
        this.endElement(elementName);
    }

    private boolean shouldPrintParameter(Object value, int index, ListenerElement descriptor) {
        boolean print = true;
        Type type = (Type)descriptor.getParameters().get(index);
        if (type instanceof Class) {
            Class typeClass = (Class)type;
            try {
                if (typeClass.isPrimitive()) {
                    print = !XMLUtils.defaultValue(typeClass).equals(value);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return print;
    }

    private void printParameters(List<Object> parameters, ListenerElement descriptor) {
        if (parameters != null && !parameters.isEmpty()) {
            for (int i = 0; i < parameters.size(); ++i) {
                Object value = parameters.get(i);
                if (value == null || !this.shouldPrintParameter(value, i, descriptor)) continue;
                this.startElement(this.configuration.getElementParameter() + i);
                this.parameterManager.serialize((Type)descriptor.getParameters().get(i), value, this.contentHandler);
                this.endElement(this.configuration.getElementParameter() + i);
            }
        }
    }

    private void startElement(String elemntName) {
        this.startElement(elemntName, (String[][])null);
    }

    private void startElement(String elemntName, String[][] parameters) {
        this.startElement(elemntName, this.createAttributes(parameters));
    }

    private void startElement(String elemntName, Attributes attributes) {
        try {
            this.contentHandler.startElement("", elemntName, elemntName, attributes);
        }
        catch (SAXException e) {
            throw new RuntimeException("Failed to send sax event", e);
        }
    }

    private void endElement(String elemntName) {
        try {
            this.contentHandler.endElement("", elemntName, elemntName);
        }
        catch (SAXException e) {
            throw new RuntimeException("Failed to send sax event", e);
        }
    }

    private Attributes createAttributes(String[][] parameters) {
        AttributesImpl attributes = new AttributesImpl();
        if (parameters != null && parameters.length > 0) {
            for (String[] entry : parameters) {
                attributes.addAttribute(null, null, entry[0], null, entry[1]);
            }
        }
        return attributes;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ContentHandler result = null;
        if (method.getName().equals("setContentHandler")) {
            this.contentHandler = (ContentHandler)args[0];
        } else if (method.getName().equals("getContentHandler")) {
            result = this.contentHandler;
        } else if (method.getName().startsWith("begin")) {
            this.beginEvent(method.getName(), args);
        } else if (method.getName().startsWith("end")) {
            this.endEvent(method.getName());
        } else if (method.getName().startsWith("on")) {
            this.onEvent(method.getName(), args);
        } else {
            throw new NoSuchMethodException(method.toGenericString());
        }
        return result;
    }
}

