/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.ForwardingHttpResponse;
import org.zalando.logbook.HeaderFilter;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;

@API(status=API.Status.INTERNAL)
final class FilteredHttpResponse
implements ForwardingHttpResponse {
    private final HttpResponse response;
    private final HeaderFilter headerFilter;
    private final BodyFilter bodyFilter;

    public HttpResponse delegate() {
        return this.response;
    }

    public HttpHeaders getHeaders() {
        return this.headerFilter.filter(this.response.getHeaders());
    }

    public HttpResponse withBody() throws IOException {
        return this.withResponse(this.response.withBody());
    }

    public HttpResponse withoutBody() {
        return this.withResponse(this.response.withoutBody());
    }

    private HttpResponse withResponse(HttpResponse response) {
        return new FilteredHttpResponse(response, this.headerFilter, this.bodyFilter);
    }

    public byte[] getBody() throws IOException {
        return this.getBodyAsString().getBytes(this.getCharset());
    }

    public String getBodyAsString() throws IOException {
        return this.bodyFilter.filter(this.response.getContentType(), this.response.getBodyAsString());
    }

    @Generated
    public FilteredHttpResponse(HttpResponse response, HeaderFilter headerFilter, BodyFilter bodyFilter) {
        this.response = response;
        this.headerFilter = headerFilter;
        this.bodyFilter = bodyFilter;
    }
}

