/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import lombok.Generated;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.netty.HeaderSupport;
import org.zalando.logbook.netty.State;
import org.zalando.logbook.netty.Unbuffered;

final class Request
implements HttpRequest,
HeaderSupport {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final ChannelHandlerContext context;
    private final Origin origin;
    private final io.netty.handler.codec.http.HttpRequest request;
    private final QueryStringDecoder uriDecoder;

    public Request(ChannelHandlerContext context, Origin origin, io.netty.handler.codec.http.HttpRequest request) {
        this(context, origin, request, new QueryStringDecoder(request.uri()));
    }

    public String getProtocolVersion() {
        return this.request.protocolVersion().text();
    }

    public Origin getOrigin() {
        return this.origin;
    }

    @Nullable
    public String getRemote() {
        SocketAddress remoteAddress = this.context.channel().remoteAddress();
        return remoteAddress == null ? null : remoteAddress.toString();
    }

    public String getMethod() {
        return this.request.method().name();
    }

    public String getScheme() {
        SslHandler handler = (SslHandler)this.context.channel().pipeline().get(SslHandler.class);
        return handler == null ? "http" : "https";
    }

    public String getHost() {
        String host = this.request.headers().get((CharSequence)HttpHeaderNames.HOST);
        if (host == null) {
            return this.extractAddress().map(InetSocketAddress::getHostString).orElse("unknown");
        }
        return this.stripPortIfNecessary(host);
    }

    public Optional<Integer> getPort() {
        return this.extractAddress().map(InetSocketAddress::getPort);
    }

    private String stripPortIfNecessary(String host) {
        int separator = host.indexOf(":");
        return separator == -1 ? host : host.substring(0, separator);
    }

    private Optional<InetSocketAddress> extractAddress() {
        Channel channel = this.context.channel();
        SocketAddress address = this.origin == Origin.LOCAL ? channel.remoteAddress() : channel.localAddress();
        return address instanceof InetSocketAddress ? Optional.of((InetSocketAddress)address) : Optional.empty();
    }

    public String getPath() {
        return this.uriDecoder.path();
    }

    public String getQuery() {
        return this.uriDecoder.rawQuery();
    }

    public HttpHeaders getHeaders() {
        return this.copyOf((Iterable)this.request.headers());
    }

    @Nullable
    public String getContentType() {
        return Objects.toString(HttpUtil.getMimeType((HttpMessage)this.request), null);
    }

    public Charset getCharset() {
        return HttpUtil.getCharset((HttpMessage)this.request, (Charset)StandardCharsets.UTF_8);
    }

    public HttpRequest withBody() {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpRequest withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    void buffer(ByteBuf content) {
        this.state.updateAndGet(state -> state.buffer((HttpMessage)this.request, content));
    }

    public byte[] getBody() {
        return this.state.get().getBody();
    }

    @Generated
    private Request(ChannelHandlerContext context, Origin origin, io.netty.handler.codec.http.HttpRequest request, QueryStringDecoder uriDecoder) {
        this.context = context;
        this.origin = origin;
        this.request = request;
        this.uriDecoder = uriDecoder;
    }
}

