/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.netty;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import lombok.Generated;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.netty.HeaderSupport;
import org.zalando.logbook.netty.State;
import org.zalando.logbook.netty.Unbuffered;

final class Response
implements HttpResponse,
HeaderSupport {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final Origin origin;
    private final io.netty.handler.codec.http.HttpResponse response;

    public String getProtocolVersion() {
        return this.response.protocolVersion().text();
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public int getStatus() {
        return this.response.status().code();
    }

    public HttpHeaders getHeaders() {
        return this.copyOf((Iterable)this.response.headers());
    }

    @Nullable
    public String getContentType() {
        return this.response.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
    }

    public Charset getCharset() {
        return HttpUtil.getCharset((HttpMessage)this.response, (Charset)StandardCharsets.UTF_8);
    }

    public HttpResponse withBody() {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpResponse withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    void buffer(ByteBuf content) {
        this.state.updateAndGet(state -> state.buffer((HttpMessage)this.response, content));
    }

    public byte[] getBody() {
        return this.state.get().getBody();
    }

    @Generated
    public Response(Origin origin, io.netty.handler.codec.http.HttpResponse response) {
        this.origin = origin;
        this.response = response;
    }
}

