/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.openfeign;

import feign.Logger;
import feign.Request;
import feign.Response;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.openfeign.ByteStreams;
import org.zalando.logbook.openfeign.LocalRequest;
import org.zalando.logbook.openfeign.RemoteResponse;
import org.zalando.logbook.openfeign.Utils;

@API(status=API.Status.EXPERIMENTAL)
public final class FeignLogbookLogger
extends Logger {
    private final Logbook logbook;
    private final ThreadLocal<Logbook.ResponseProcessingStage> stage = new ThreadLocal();

    @Generated
    protected void log(String configKey, String format, Object ... args) {
    }

    protected void logRetry(String configKey, Logger.Level logLevel) {
    }

    protected IOException logIOException(String configKey, Logger.Level logLevel, IOException ioe, long elapsedTime) {
        return ioe;
    }

    protected void logRequest(String configKey, Logger.Level logLevel, Request request) {
        LocalRequest httpRequest = LocalRequest.create(request);
        try {
            Logbook.ResponseProcessingStage processingStage = this.logbook.process((HttpRequest)httpRequest).write();
            this.stage.set(processingStage);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response logAndRebufferResponse(String configKey, Logger.Level logLevel, Response response, long elapsedTime) {
        try {
            byte[] body;
            if (response.body() != null) {
                InputStream bodyInputStream = null;
                try {
                    bodyInputStream = response.body().asInputStream();
                    body = ByteStreams.toByteArray(bodyInputStream);
                }
                finally {
                    Utils.ensureClosed(bodyInputStream);
                }
                Utils.ensureClosed((Closeable)response.body());
            } else {
                body = null;
            }
            RemoteResponse httpResponse = RemoteResponse.create(response, body);
            this.stage.get().process((HttpResponse)httpResponse).write();
            return Response.builder().status(response.status()).request(response.request()).reason(response.reason()).headers(response.headers()).body(body).build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Generated
    public FeignLogbookLogger(Logbook logbook) {
        this.logbook = logbook;
    }
}

