/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.glossary;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.zanata.adapter.glossary.AbstractGlossaryPushReader;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.GlossaryEntry;
import org.zanata.rest.dto.GlossaryTerm;

public class GlossaryCSVReader
extends AbstractGlossaryPushReader {
    private final int batchSize;
    private final LocaleId srcLang;
    private static final String POS = "POS";
    private static final String DESC = "DESCRIPTION";

    public GlossaryCSVReader(LocaleId srcLang, int batchSize) {
        this.srcLang = srcLang;
        this.batchSize = batchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<GlossaryEntry>> extractGlossary(Reader reader) throws IOException {
        int entryCount = 0;
        try (CSVReader csvReader = new CSVReader(reader);){
            ArrayList<List<GlossaryEntry>> glossaries = new ArrayList<List<GlossaryEntry>>();
            List entries = csvReader.readAll();
            this.validateCSVEntries(entries);
            Map<String, Integer> descriptionMap = this.setupDescMap(entries);
            Map<Integer, LocaleId> localeColMap = this.setupLocalesMap(entries, descriptionMap);
            LocaleId srcLocale = localeColMap.get(0);
            if (!this.srcLang.equals((Object)srcLocale)) {
                throw new RuntimeException("input source language '" + this.srcLang + "' does not match source language in file '" + srcLocale + "'");
            }
            ArrayList<GlossaryEntry> glossaryEntries = new ArrayList<GlossaryEntry>();
            for (int i = 1; i < entries.size(); ++i) {
                String[] row = (String[])entries.get(i);
                GlossaryEntry entry = new GlossaryEntry();
                entry.setSrcLang(srcLocale);
                entry.setPos(row[descriptionMap.get(POS)]);
                entry.setDescription(row[descriptionMap.get(DESC)]);
                for (int x = 0; x < row.length && localeColMap.containsKey(x); ++x) {
                    LocaleId locale = localeColMap.get(x);
                    String content = row[x];
                    GlossaryTerm term = new GlossaryTerm();
                    term.setLocale(locale);
                    term.setContent(content);
                    entry.getGlossaryTerms().add(term);
                }
                glossaryEntries.add(entry);
                if (++entryCount != this.batchSize && i != entries.size() - 1) continue;
                glossaries.add(glossaryEntries);
                entryCount = 0;
                glossaryEntries = new ArrayList();
            }
            ArrayList<List<GlossaryEntry>> arrayList = glossaries;
            return arrayList;
        }
    }

    private void validateCSVEntries(@Nonnull List<String[]> entries) {
        if (entries.isEmpty()) {
            throw new RuntimeException("Invalid CSV file - empty file");
        }
        if (entries.size() < 2) {
            throw new RuntimeException("Invalid CSV file - no entries found");
        }
        for (String[] row : entries) {
            if (entries.get(0).length == row.length) continue;
            throw new RuntimeException("Invalid CSV file - inconsistency of columns with header");
        }
    }

    private Map<Integer, LocaleId> setupLocalesMap(List<String[]> entries, Map<String, Integer> descriptionMap) {
        HashMap<Integer, LocaleId> localeColMap = new HashMap<Integer, LocaleId>();
        String[] headerRow = entries.get(0);
        for (int row = 0; row < headerRow.length && !descriptionMap.containsValue(row); ++row) {
            LocaleId locale = new LocaleId(headerRow[row]);
            localeColMap.put(row, locale);
        }
        return localeColMap;
    }

    private Map<String, Integer> setupDescMap(List<String[]> entries) {
        HashMap<String, Integer> descMap = new HashMap<String, Integer>();
        String[] headerRow = entries.get(0);
        descMap.put(POS, headerRow.length - 2);
        descMap.put(DESC, headerRow.length - 1);
        return descMap;
    }
}

