/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.po;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.fedorahosted.tennera.jgettext.HeaderFields;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.PoWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.common.ContentState;
import org.zanata.common.io.DigestWriter;
import org.zanata.common.io.FileDetails;
import org.zanata.rest.dto.extensions.comment.SimpleComment;
import org.zanata.rest.dto.extensions.gettext.HeaderEntry;
import org.zanata.rest.dto.extensions.gettext.PoHeader;
import org.zanata.rest.dto.extensions.gettext.PoTargetHeader;
import org.zanata.rest.dto.extensions.gettext.PotEntryHeader;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.util.PathUtil;

public class PoWriter2 {
    private static final Logger log = LoggerFactory.getLogger(PoWriter2.class);
    private static final int DEFAULT_NPLURALS = 1;
    private static final String CONTINUE_ERROR_MESSAGE_FMT = "%s. %s, please use --continue-after-error option.";
    private final PoWriter poWriter;
    private boolean mapIdToMsgctxt;
    private boolean continueAfterError;
    private static final Pattern pluralPattern = Pattern.compile("nplurals(\\s*?)=(\\s*?)(\\d*?)(\\s*?);(\\s*?)(.*)", 2);

    public PoWriter2(boolean encodeTabs, boolean mapIdToMsgctxt, boolean continueAfterError) {
        this.continueAfterError = continueAfterError;
        this.poWriter = new PoWriter(encodeTabs);
        this.mapIdToMsgctxt = mapIdToMsgctxt;
    }

    public PoWriter2(boolean encodeTabs, boolean mapIdToMsgctxt) {
        this(encodeTabs, mapIdToMsgctxt, false);
    }

    public PoWriter2(boolean encodeTabs) {
        this(encodeTabs, false, false);
    }

    public PoWriter2() {
        this(false);
    }

    @Deprecated
    public void writePot(File baseDir, Resource doc) throws IOException {
        File potDir = new File(baseDir, "pot");
        this.writePotToDir(potDir, doc);
    }

    @Deprecated
    public void writePotToDir(File potDir, Resource doc) throws IOException {
        File potFile = new File(potDir, doc.getName() + ".pot");
        this.writePotToFile(potFile, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePotToFile(File potFile, Resource doc) throws IOException {
        PathUtil.makeParents((File)potFile);
        try (OutputStreamWriter fWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(potFile), Charsets.UTF_8);){
            this.write(fWriter, "UTF-8", doc, null);
        }
    }

    public void writePot(OutputStream stream, String charset, Resource doc) throws IOException {
        OutputStreamWriter osWriter = new OutputStreamWriter(stream, charset);
        this.write(osWriter, charset, doc, null);
        osWriter.flush();
    }

    @Deprecated
    public void writePo(File baseDir, Resource doc, String locale, TranslationsResource targetDoc) throws IOException {
        File localeDir = new File(baseDir, locale);
        File poFile = new File(localeDir, doc.getName() + ".po");
        this.writePoToFile(poFile, doc, targetDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDetails writePoToFile(File poFile, Resource doc, TranslationsResource targetDoc) throws IOException {
        MessageDigest md5Digest;
        PathUtil.makeDirs((File)poFile.getParentFile());
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try (OutputStreamWriter fWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(poFile), Charsets.UTF_8);){
            DigestWriter dWriter = new DigestWriter((Writer)fWriter, md5Digest);
            this.write((Writer)dWriter, "UTF-8", doc, targetDoc);
            FileDetails details = new FileDetails(poFile);
            details.setMd5(new String(Hex.encodeHex((byte[])md5Digest.digest())));
            FileDetails fileDetails = details;
            return fileDetails;
        }
    }

    public void writePo(OutputStream stream, String charset, Resource doc, TranslationsResource targetDoc) throws IOException {
        OutputStreamWriter osWriter = new OutputStreamWriter(stream, charset);
        this.write(osWriter, charset, doc, targetDoc);
        osWriter.flush();
    }

    private void write(Writer writer, String charset, Resource document, TranslationsResource targetDoc) throws IOException {
        PoHeader poHeader = (PoHeader)document.getExtensions(true).findByType(PoHeader.class);
        HeaderFields hf = new HeaderFields();
        if (poHeader == null) {
            if (!this.mapIdToMsgctxt) {
                log.warn("No PO header in document named " + document.getName());
            }
        } else {
            PoWriter2.copyToHeaderFields(hf, poHeader.getEntries());
        }
        PoWriter2.setEncodingHeaderFields(hf, charset);
        HashMap<String, TextFlowTarget> targets = new HashMap<String, TextFlowTarget>();
        Message headerMessage = null;
        int nPlurals = 1;
        if (targetDoc != null) {
            PoTargetHeader poTargetHeader = (PoTargetHeader)targetDoc.getExtensions(true).findByType(PoTargetHeader.class);
            if (poTargetHeader != null) {
                PoWriter2.copyToHeaderFields(hf, poTargetHeader.getEntries());
                headerMessage = hf.unwrap();
                headerMessage.setFuzzy(false);
                PoWriter2.copyCommentsToHeader(poTargetHeader, headerMessage);
                nPlurals = PoWriter2.extractNPlurals(poTargetHeader);
            }
            for (TextFlowTarget target : targetDoc.getTextFlowTargets()) {
                targets.put(target.getResId(), target);
            }
        }
        if (headerMessage == null) {
            headerMessage = hf.unwrap();
        }
        this.poWriter.write(headerMessage, writer);
        writer.write("\n");
        for (TextFlow textFlow : document.getTextFlows()) {
            PotEntryHeader entryData = (PotEntryHeader)textFlow.getExtensions(true).findByType(PotEntryHeader.class);
            SimpleComment srcComment = (SimpleComment)textFlow.getExtensions().findByType(SimpleComment.class);
            Message message = new Message();
            this.copyTFContentsToMessage(textFlow, message);
            ArrayList<String> tftContents = new ArrayList<String>();
            TextFlowTarget tfTarget = (TextFlowTarget)targets.get(textFlow.getId());
            if (tfTarget != null) {
                if (!tfTarget.getResId().equals(textFlow.getId())) {
                    throw new RuntimeException("ID from target doesn't match text-flow ID");
                }
                tftContents.addAll(tfTarget.getContents());
                if (tfTarget.getState() == ContentState.NeedReview) {
                    message.setFuzzy(true);
                }
                this.copyCommentsToMessage(tfTarget, message);
            }
            this.copyTFTContentsToMessage(document.getName(), textFlow, tftContents, nPlurals, message);
            if (entryData != null) {
                PoWriter2.copyMetadataToMessage(entryData, srcComment, message);
            } else if (!this.mapIdToMsgctxt) {
                log.warn("Missing POT entry for text-flow ID " + textFlow.getId());
            }
            if (this.mapIdToMsgctxt) {
                this.mapIdToMsgctxt(message, textFlow.getId());
            }
            this.poWriter.write(message, writer);
            writer.write("\n");
        }
    }

    private void mapIdToMsgctxt(Message message, String textFlowId) {
        if (message.getMsgctxt() != null) {
            throw new RuntimeException("Mapping id to msgctxt, but there is already a msgctxt for text flow id: " + textFlowId);
        }
        message.setMsgctxt(textFlowId);
    }

    private static void copyCommentsToHeader(PoTargetHeader poTargetHeader, Message headerMessage) {
        for (String s : poTargetHeader.getComment().split("\n")) {
            headerMessage.addComment(s);
        }
    }

    private void copyTFContentsToMessage(TextFlow textFlow, Message message) {
        List tfContents = textFlow.getContents();
        message.setMsgid((String)tfContents.get(0));
        if (textFlow.isPlural()) {
            if (tfContents.size() < 1) {
                throw new RuntimeException("textflow has plural flag but only has one form: resId=" + textFlow.getId());
            }
            message.setMsgidPlural((String)tfContents.get(1));
        } else if (tfContents.size() > 1) {
            if (this.continueAfterError) {
                log.warn("textflow has no plural flag but has multiple plural forms: resId={}", (Object)textFlow.getId());
            } else {
                PoWriter2.throwContinueableException("textflow has no plural flag but multiple plural forms: [resId=" + textFlow.getId() + "]. This is likely caused by changed plural forms", "To write content as singular form and continue");
            }
        }
        if (tfContents.size() > 2) {
            throw new RuntimeException("POT format only supports 2 plural forms: resId=" + textFlow.getId());
        }
    }

    private static void throwContinueableException(String specificErrorMessage, String specificRemedy) {
        throw new RuntimeException(String.format(CONTINUE_ERROR_MESSAGE_FMT, specificErrorMessage, specificRemedy));
    }

    private void copyCommentsToMessage(TextFlowTarget tfTarget, Message message) {
        String[] comments;
        SimpleComment poComment = (SimpleComment)tfTarget.getExtensions().findByType(SimpleComment.class);
        if (!(poComment == null || (comments = poComment.getValue().split("\n")).length == 1 && comments[0].isEmpty())) {
            for (String comment : comments) {
                message.getComments().add(comment);
            }
        }
    }

    private void copyTFTContentsToMessage(String docName, TextFlow textFlow, List<String> tftContents, int nPlurals, Message message) {
        if (message.isPlural()) {
            while (tftContents.size() < nPlurals) {
                tftContents.add("");
            }
            for (int i = 0; i < tftContents.size(); ++i) {
                message.addMsgstrPlural(tftContents.get(i), i);
            }
            if (tftContents.size() > nPlurals) {
                log.warn("Marking as fuzzy: too many plural forms for text flow: resId={}, doc={}", (Object)textFlow.getId(), (Object)docName);
                message.setFuzzy(true);
            }
        } else if (tftContents.size() == 0) {
            message.setMsgstr("");
        } else {
            message.setMsgstr(tftContents.get(0));
            if (tftContents.size() > 1) {
                log.warn("Marking as fuzzy: unexpected plural translation found for text flow: resId={}, doc={}", (Object)textFlow.getId(), (Object)docName);
                message.setFuzzy(true);
            }
        }
    }

    static void setEncodingHeaderFields(HeaderFields hf, String charset) {
        hf.setValue("MIME-Version", "1.0");
        hf.setValue("Content-Transfer-Encoding", "8bit");
        String contentType = hf.getValue("Content-Type");
        String ct = contentType == null ? "text/plain; charset=" + charset : contentType.replaceFirst("charset=[^;]*", "charset=" + charset);
        hf.setValue("Content-Type", ct);
    }

    static void copyToHeaderFields(HeaderFields hf, List<HeaderEntry> entries) {
        for (HeaderEntry e : entries) {
            hf.setValue(e.getKey(), e.getValue());
        }
    }

    private static void copyMetadataToMessage(PotEntryHeader data, SimpleComment simpleComment, Message message) {
        String[] comments;
        if (data != null) {
            String context = data.getContext();
            if (context != null) {
                message.setMsgctxt(context);
            }
            for (String flag : data.getFlags()) {
                message.addFormat(flag);
            }
            for (String ref : data.getReferences()) {
                message.addSourceReference(ref);
            }
        }
        if (!(simpleComment == null || (comments = StringUtils.splitPreserveAllTokens((String)simpleComment.getValue(), (String)"\n")).length == 1 && comments[0].isEmpty())) {
            for (String comment : comments) {
                message.addExtractedComment(comment);
            }
        }
    }

    private static int extractNPlurals(PoTargetHeader header) {
        for (HeaderEntry entry : header.getEntries()) {
            Matcher pluralMatcher;
            if (!entry.getKey().equals("Plural-Forms") || !(pluralMatcher = pluralPattern.matcher(entry.getValue())).find()) continue;
            String pluralStr = pluralMatcher.group(3);
            return Integer.parseInt(pluralStr);
        }
        return 1;
    }
}

