/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.properties;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import org.fedorahosted.openprops.Properties;
import org.zanata.adapter.properties.PropWriter;
import org.zanata.common.ContentState;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.ExtensionValue;
import org.zanata.rest.dto.extensions.comment.SimpleComment;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.util.HashUtil;

public class PropReader {
    public static final String PROP_CONTENT_TYPE = "text/plain";
    private static final String NEWLINE_REGEX = "(\r\n|\r|\n)";
    private final PropWriter.CHARSET charset;
    private final LocaleId sourceLocale;
    private final ContentState contentState;

    public PropReader(PropWriter.CHARSET charset, LocaleId sourceLocale, ContentState contentState) {
        this.charset = charset;
        this.sourceLocale = sourceLocale;
        this.contentState = contentState;
    }

    public PropReader() {
        this(PropWriter.CHARSET.Latin1, LocaleId.EN_US, ContentState.Translated);
    }

    @Deprecated
    public void extractTarget(TranslationsResource doc, InputStream in) throws IOException, RuntimeException {
        this.extractTarget(doc, in, Collections.emptyMap());
    }

    public void extractTarget(TranslationsResource doc, InputStream in, Resource srcDoc) throws IOException, RuntimeException {
        HashMap keyToSourceContentsMap = Maps.newHashMap();
        for (TextFlow tf : srcDoc.getTextFlows()) {
            keyToSourceContentsMap.put(tf.getId(), tf.getContents());
        }
        this.extractTarget(doc, in, keyToSourceContentsMap);
    }

    private void extractTarget(TranslationsResource doc, InputStream in, Map<String, List<String>> keyToSourceContentsMap) throws IOException, RuntimeException {
        Properties props = this.loadProps(in);
        for (String key : props.keySet()) {
            List<String> sourceContents = keyToSourceContentsMap.get(key);
            String sourceHash = sourceContents == null ? null : HashUtil.sourceHash(sourceContents);
            this.addPropEntryToDoc(doc, props, key, this.contentState, sourceHash);
        }
    }

    private void addPropEntryToDoc(TranslationsResource doc, Properties props, String key, ContentState contentState, String sourceHash) {
        String content = props.getProperty(key);
        if (content == null) {
            return;
        }
        TextFlowTarget textFlowTarget = new TextFlowTarget(key);
        textFlowTarget.setSourceHash(sourceHash);
        textFlowTarget.setContents(new String[]{content});
        if (!content.isEmpty()) {
            textFlowTarget.setState(contentState);
        } else {
            textFlowTarget.setState(ContentState.New);
        }
        String comment = props.getComment(key);
        if (comment != null && comment.length() != 0) {
            SimpleComment simpleComment = new SimpleComment(comment);
            textFlowTarget.getExtensions(true).add((ExtensionValue)simpleComment);
        }
        doc.getTextFlowTargets().add(textFlowTarget);
    }

    public void extractTemplate(Resource doc, InputStream in) throws IOException, RuntimeException {
        List resources = doc.getTextFlows();
        Properties props = this.loadProps(in);
        int nonTranslatableCount = 0;
        for (String key : props.stringPropertyNames()) {
            String comment = null;
            String rawComment = props.getRawComment(key);
            if (rawComment != null && rawComment.length() != 0) {
                StringBuilder sb = new StringBuilder(rawComment.length());
                nonTranslatableCount = this.processCommentForNonTranslatable(nonTranslatableCount, rawComment, sb);
                comment = sb.toString();
            }
            if (nonTranslatableCount != 0) continue;
            String content = props.getProperty(key);
            String id = this.getID(key, content);
            TextFlow textFlow = new TextFlow(id, this.sourceLocale, new String[]{content});
            if (comment != null && comment.length() != 0) {
                SimpleComment simpleComment = new SimpleComment(comment);
                textFlow.getExtensions(true).add((ExtensionValue)simpleComment);
            }
            resources.add(textFlow);
        }
    }

    private int processCommentForNonTranslatable(int nonTranslatableCount, String comment, StringBuilder sb) throws InvalidPropertiesFormatException {
        String[] lines;
        int nonTranslatable = nonTranslatableCount;
        for (String line : lines = comment.split(NEWLINE_REGEX)) {
            int lineNonTranslatable = this.checkNonTranslatable(line);
            if ((nonTranslatable += lineNonTranslatable) < 0) {
                throw new InvalidPropertiesFormatException("Found '# END NON-TRANSLATABLE' without matching '# START NON-TRANSLATABLE'");
            }
            if (nonTranslatable != 0 || lineNonTranslatable != 0) continue;
            sb.append(Properties.cookCommentLine((String)line));
            sb.append('\n');
        }
        return nonTranslatable;
    }

    private int checkNonTranslatable(String line) {
        if (line.startsWith("# START NON-TRANSLATABLE")) {
            return 1;
        }
        if (line.startsWith("# END NON-TRANSLATABLE")) {
            return -1;
        }
        return 0;
    }

    private String getID(String key, String val) throws RuntimeException {
        if (key.length() > 255) {
            throw new RuntimeException("Zanata does not support property keys exceeding 255 characters");
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProps(InputStream in) throws IOException, RuntimeException {
        try (InputStreamReader reader = new InputStreamReader(in, this.charset.getAlias());){
            Properties props = new Properties();
            props.load((Reader)reader);
            Properties properties = props;
            return properties;
        }
    }
}

