/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.xliff;

import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.zanata.adapter.xliff.XliffCommon;
import org.zanata.rest.dto.extensions.comment.SimpleComment;
import org.zanata.rest.dto.extensions.gettext.TextFlowExtension;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.util.PathUtil;

public class XliffWriter
extends XliffCommon {
    private static void writeHeader(XMLStreamWriter writer, Resource doc, String targetLocale) throws XMLStreamException {
        writer.writeStartDocument("utf-8", "1.0");
        writer.writeComment("XLIFF document generated by Zanata. Visit http://zanata.org for more infomation.");
        writer.writeCharacters("\n");
        writer.writeStartElement("xliff");
        writer.writeNamespace("", "urn:oasis:names:tc:xliff:document:1.1");
        writer.writeNamespace("xyz", "urn:appInfo:Items");
        writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttribute("xsi:schemaLocation", "urn:oasis:names:tc:xliff:document:1.1 http://www.oasis-open.org/committees/xliff/documents/xliff-core-1.1.xsd");
        writer.writeAttribute("version", "1.1");
        writer.writeStartElement("file");
        writer.writeAttribute("source-language", doc.getLang().getId());
        writer.writeAttribute("datatype", "plaintext");
        writer.writeAttribute("original", "");
        if (targetLocale != null) {
            writer.writeAttribute("target-language", targetLocale);
        }
        writer.writeStartElement("body");
    }

    private static void writeTransUnits(XMLStreamWriter writer, Resource doc, TranslationsResource targetDoc, boolean createSkeletons) throws XMLStreamException {
        Map<String, TextFlowTarget> targets = Collections.emptyMap();
        if (targetDoc != null) {
            targets = new HashMap();
            for (TextFlowTarget target : targetDoc.getTextFlowTargets()) {
                targets.put(target.getResId(), target);
            }
        }
        for (TextFlow textFlow : doc.getTextFlows()) {
            TextFlowTarget target = (TextFlowTarget)targets.get(textFlow.getId());
            if (target == null && !createSkeletons) continue;
            writer.writeStartElement("trans-unit");
            writer.writeAttribute("id", textFlow.getId());
            XliffWriter.writeTransUnitSource(writer, textFlow);
            if (target != null && target.getState().isTranslated()) {
                XliffWriter.writeTransUnitTarget(writer, target);
            }
            XliffWriter.writeTransUnitContext(writer, textFlow);
            writer.writeEndElement();
        }
    }

    private static void writeTransUnitSource(XMLStreamWriter writer, TextFlow textFlow) throws XMLStreamException {
        writer.writeStartElement("source");
        List contents = textFlow.getContents();
        if (contents.size() != 1) {
            throw new RuntimeException("file format does not support plural forms: resId=" + textFlow.getId());
        }
        writer.writeCharacters((String)contents.get(0));
        writer.writeEndElement();
    }

    private static void writeTransUnitTarget(XMLStreamWriter writer, TextFlowTarget target) throws XMLStreamException {
        writer.writeStartElement("target");
        List contents = target.getContents();
        if (contents.size() != 1) {
            throw new RuntimeException("file format does not support plural forms: resId=" + target.getResId());
        }
        writer.writeCharacters((String)contents.get(0));
        writer.writeEndElement();
    }

    private static void writeTransUnitContext(XMLStreamWriter writer, TextFlow textFlow) throws XMLStreamException {
        if (!textFlow.getExtensions(true).isEmpty()) {
            HashMap<String, ArrayList> contextGroupMap = new HashMap<String, ArrayList>();
            for (TextFlowExtension textFlowExtension : textFlow.getExtensions()) {
                ArrayList list;
                SimpleComment comment = (SimpleComment)textFlowExtension;
                String[] contextValues = comment.getValue().split("::", 3);
                if (!contextGroupMap.containsKey(contextValues[0])) {
                    list = new ArrayList();
                    list.add(new String[]{contextValues[1], contextValues[2]});
                    contextGroupMap.put(contextValues[0], list);
                    continue;
                }
                list = (ArrayList)contextGroupMap.get(contextValues[0]);
                list.add(new String[]{contextValues[1], contextValues[2]});
            }
            for (Map.Entry entry : contextGroupMap.entrySet()) {
                String key = (String)entry.getKey();
                ArrayList values = (ArrayList)entry.getValue();
                writer.writeStartElement("context-group");
                writer.writeAttribute("name", key);
                for (String[] val : values) {
                    writer.writeStartElement("context");
                    writer.writeAttribute("context-type", val[0]);
                    writer.writeCharacters(val[1]);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
    }

    public static void write(File baseDir, Resource doc, String locale, TranslationsResource targetDoc, boolean createSkeletons) {
        File outFile = new File(baseDir, doc.getName() + "_" + locale.replace('-', '_') + ".xml");
        XliffWriter.writeFile(outFile, doc, locale, targetDoc, createSkeletons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, Resource doc, String locale, TranslationsResource targetDoc, boolean createSkeletons) {
        try {
            PathUtil.makeParents((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing XLIFF file  ", e);
        }
        try (FileOutputStream fileStream = new FileOutputStream(file);){
            XMLOutputFactory output = XMLOutputFactory.newInstance();
            try (IndentingXMLStreamWriter writer = new IndentingXMLStreamWriter(output.createXMLStreamWriter(fileStream, "utf-8"));){
                XliffWriter.writeHeader((XMLStreamWriter)writer, doc, locale);
                XliffWriter.writeTransUnits((XMLStreamWriter)writer, doc, targetDoc, createSkeletons);
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndDocument();
                writer.flush();
            }
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException("Error writing XLIFF file", e);
        }
    }

    public static void write(File baseDir, Resource doc, String locale) {
        XliffWriter.write(baseDir, doc, locale, null, true);
    }
}

