/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.PushPullType;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.RawPushStrategy;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.exceptions.ConfigException;
import org.zanata.client.exceptions.InvalidUserInputException;
import org.zanata.client.util.ConsoleUtils;
import org.zanata.common.DocumentType;
import org.zanata.rest.DocumentFileUploadForm;
import org.zanata.rest.client.FileResourceClient;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.ChunkUploadResponse;

public class RawPushCommand
extends PushPullCommand<PushOptions> {
    private static final Logger log = LoggerFactory.getLogger(PushCommand.class);
    private static final Pattern fileNameExtensionsPattern = Pattern.compile("(?:([^\\[]*)?(?:\\[(.*?)\\])?)");
    private final ConsoleInteractor consoleInteractor;
    private FileResourceClient client = this.getClientFactory().getFileResourceClient();

    public RawPushCommand(PushOptions opts) {
        super(opts);
        this.consoleInteractor = new ConsoleInteractorImpl(opts);
    }

    public RawPushCommand(PushOptions opts, RestClientFactory clientFactory) {
        super(opts, clientFactory);
        this.consoleInteractor = new ConsoleInteractorImpl(opts);
    }

    public RawPushCommand(PushOptions opts, RestClientFactory clientFactory, ConsoleInteractor console) {
        super(opts, clientFactory);
        this.consoleInteractor = console;
    }

    public List<String> extractExtensions(String typeWithExtension) {
        String rawExtensions;
        Matcher matcher = fileNameExtensionsPattern.matcher(typeWithExtension);
        if (matcher.find() && !StringUtils.isEmpty((String)(rawExtensions = matcher.group(2)))) {
            return Arrays.asList(rawExtensions.split(";"));
        }
        return Collections.emptyList();
    }

    @Nullable
    public String extractType(String typeWithExtension) {
        Matcher matcher = fileNameExtensionsPattern.matcher(typeWithExtension);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private void validateInputFileType(String inputFileType, List<String> inputExtensions, List<DocumentType> acceptedTypes) {
        if (StringUtils.isNotBlank((String)inputFileType)) {
            return;
        }
        if (inputExtensions.isEmpty()) {
            throw new InvalidUserInputException("Invalid expression for '--file-types' option");
        }
        for (DocumentType docType : acceptedTypes) {
            for (String extension : docType.getSourceExtensions()) {
                if (!inputExtensions.contains(extension)) continue;
                String msg = Messages.format("file.type.suggestFromExtension", docType, extension, docType);
                throw new InvalidUserInputException(msg);
            }
        }
    }

    public Map<DocumentType, Set<String>> validateFileTypes(List<DocumentType> acceptedTypes, List<String> inputFileTypes) {
        HashMap<DocumentType, Set<String>> filteredFileTypes = new HashMap<DocumentType, Set<String>>();
        for (String typeWithExtension : inputFileTypes) {
            String msg;
            String fileType = this.extractType(typeWithExtension);
            List<String> extensions = this.extractExtensions(typeWithExtension);
            this.validateInputFileType(fileType, extensions, acceptedTypes);
            DocumentType inputFileType = DocumentType.getByName((String)fileType);
            if (inputFileType == null) {
                msg = Messages.format("file.type.typeNotSupported", fileType);
                this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Warning, msg, new Object[0]);
                continue;
            }
            if (filteredFileTypes.containsKey(inputFileType)) {
                msg = Messages.format("file.type.duplicateFileType", fileType);
                log.error(msg);
                throw new RuntimeException(msg);
            }
            HashSet<String> filteredExtensions = new HashSet<String>(extensions);
            filteredExtensions = filteredExtensions.isEmpty() ? inputFileType.getSourceExtensions() : filteredExtensions;
            for (Map.Entry entry : filteredFileTypes.entrySet()) {
                for (String filteredExtension : (Set)entry.getValue()) {
                    if (!filteredExtensions.contains(filteredExtension)) continue;
                    String msg2 = Messages.format("file.type.conflictExtension", fileType, ((DocumentType)entry.getKey()).name(), filteredExtension);
                    log.error(msg2);
                    throw new RuntimeException(msg2);
                }
            }
            filteredFileTypes.put(inputFileType, filteredExtensions);
        }
        return filteredFileTypes;
    }

    @Override
    public void run() throws IOException {
        PushCommand.logOptions(log, (PushOptions)this.getOpts());
        this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Warning, "Using EXPERIMENTAL project type 'file'.", new Object[0]);
        File sourceDir = ((PushOptions)this.getOpts()).getSrcDir();
        if (!sourceDir.exists()) {
            boolean enableModules = ((PushOptions)this.getOpts()).getEnableModules();
            if (enableModules) {
                this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Warning, "enableModules=true but multi-modules not yet supported for this command. Using single module push.", new Object[0]);
            }
            throw new RuntimeException("directory '" + sourceDir + "' does not exist - check " + ((PushOptions)this.getOpts()).getSrcDirParameterName() + " option");
        }
        RawPushStrategy strat = new RawPushStrategy();
        strat.setPushOptions((PushOptions)this.getOpts());
        List serverAcceptedTypes = this.client.acceptedFileTypes();
        Map<DocumentType, Set<String>> filteredDocTypes = this.validateFileTypes(serverAcceptedTypes, (List<String>)((PushOptions)this.getOpts()).getFileTypes());
        if (filteredDocTypes.isEmpty()) {
            log.info("no valid types specified; nothing to do");
            return;
        }
        ImmutableList.Builder sourceFileExtensionsBuilder = ImmutableList.builder();
        for (Set<String> filteredSourceExtensions : filteredDocTypes.values()) {
            sourceFileExtensionsBuilder.addAll(filteredSourceExtensions);
        }
        String[] srcFiles = strat.getSrcFiles(sourceDir, ((PushOptions)this.getOpts()).getIncludes(), ((PushOptions)this.getOpts()).getExcludes(), (ImmutableList<String>)sourceFileExtensionsBuilder.build(), true, ((PushOptions)this.getOpts()).getCaseSensitive());
        TreeSet<String> localDocNames = new TreeSet<String>(Arrays.asList(srcFiles));
        this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Warning, "Obsolete document removal is not yet implemented, no documents will be removed from the server.", new Object[0]);
        SortedSet<String> docsToPush = localDocNames;
        if (((PushOptions)this.getOpts()).getFromDoc() != null) {
            if (!localDocNames.contains(((PushOptions)this.getOpts()).getFromDoc())) {
                log.error("Document with id {} not found, unable to start push from unknown document. Aborting.", (Object)((PushOptions)this.getOpts()).getFromDoc());
                return;
            }
            docsToPush = localDocNames.tailSet(((PushOptions)this.getOpts()).getFromDoc());
            int numSkippedDocs = localDocNames.size() - docsToPush.size();
            log.info("Skipping {} document(s) before {}.", (Object)numSkippedDocs, (Object)((PushOptions)this.getOpts()).getFromDoc());
        }
        if (docsToPush.isEmpty()) {
            log.info("no documents in module: {}; nothing to do", (Object)((PushOptions)this.getOpts()).getCurrentModule());
            return;
        }
        this.consoleInteractor.printfln("Found source documents:", new Object[0]);
        for (String docName : localDocNames) {
            if (docsToPush.contains(docName)) {
                DocumentType fileType = this.getFileType(filteredDocTypes, FilenameUtils.getExtension((String)docName));
                this.consoleInteractor.printfln("           " + Messages.format("push.info.documentToPush", docName, fileType.name()), new Object[0]);
                continue;
            }
            this.consoleInteractor.printfln(Messages.format("push.info.skipDocument", docName), new Object[0]);
        }
        if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Trans || ((PushOptions)this.getOpts()).getPushType() == PushPullType.Both) {
            if (((PushOptions)this.getOpts()).getLocaleMapList() == null) {
                throw new ConfigException("pushType set to '" + (Object)((Object)((PushOptions)this.getOpts()).getPushType()) + "', but project has no locales configured");
            }
            this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Warning, Messages.format("push.warn.overrideTranslations", new Object[]{((PushOptions)this.getOpts()).getPushType()}), new Object[0]);
            if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Both) {
                this.confirmWithUser("This will overwrite existing documents AND TRANSLATIONS on the server.\n");
            } else if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Trans) {
                this.confirmWithUser("This will overwrite existing TRANSLATIONS on the server.\n");
            }
        } else {
            this.confirmWithUser("This will overwrite existing documents on the server.\n");
        }
        boolean hasErrors = false;
        for (String localDocName : docsToPush) {
            try {
                String srcExtension = FilenameUtils.getExtension((String)localDocName);
                final DocumentType fileType = this.getFileType(filteredDocTypes, srcExtension);
                final String qualifiedDocName = this.qualifiedDocName(localDocName);
                if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Source || ((PushOptions)this.getOpts()).getPushType() == PushPullType.Both) {
                    if (!((PushOptions)this.getOpts()).isDryRun()) {
                        boolean sourcePushed = this.pushSourceDocumentToServer(sourceDir, localDocName, qualifiedDocName, fileType.name());
                        if (!sourcePushed) {
                            hasErrors = true;
                        }
                    } else {
                        log.info("pushing source doc [qualifiedname={}] to server (skipped due to dry run)", (Object)qualifiedDocName);
                    }
                }
                if (((PushOptions)this.getOpts()).getPushType() != PushPullType.Trans && ((PushOptions)this.getOpts()).getPushType() != PushPullType.Both) continue;
                Optional<String> translationFileExtension = this.getTranslationFileExtension(fileType, srcExtension);
                strat.visitTranslationFiles(localDocName, new RawPushStrategy.TranslationFilesVisitor(){

                    @Override
                    public void visit(LocaleMapping locale, File translatedDoc) {
                        log.info("pushing {} translation of {}", (Object)locale.getLocale(), (Object)qualifiedDocName);
                        RawPushCommand.this.pushDocumentToServer(qualifiedDocName, fileType.name(), locale.getLocale(), translatedDoc);
                    }
                }, translationFileExtension);
            }
            catch (IOException | RuntimeException e) {
                log.error("Operation failed: " + e.getMessage() + "\n\n" + "    To retry from the last document, please add the option: {}\n", (Object)((PushOptions)this.getOpts()).buildFromDocArgument(localDocName));
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (hasErrors) {
            throw new RuntimeException("Push completed with errors, see log for details.");
        }
    }

    private Optional<String> getTranslationFileExtension(DocumentType docType, String srcExtension) {
        String transFileExtension = (String)docType.getExtensions().get(srcExtension);
        return StringUtils.isEmpty((String)transFileExtension) ? Optional.of((Object)srcExtension) : Optional.of((Object)transFileExtension);
    }

    @Nullable
    private DocumentType getFileType(Map<DocumentType, Set<String>> fileTypes, String srcExtension) {
        for (Map.Entry<DocumentType, Set<String>> entry : fileTypes.entrySet()) {
            if (!entry.getValue().contains(srcExtension)) continue;
            return entry.getKey();
        }
        return null;
    }

    private boolean pushSourceDocumentToServer(File sourceDir, String localDocName, String qualifiedDocName, String fileType) throws IOException {
        log.info("pushing source document [{}] to server", (Object)qualifiedDocName);
        String locale = null;
        File srcFile = new File(sourceDir, localDocName);
        this.pushDocumentToServer(qualifiedDocName, fileType, locale, srcFile);
        return true;
    }

    private void pushDocumentToServer(String docId, String fileType, String locale, File docFile) {
        block29: {
            try {
                String md5hash = this.calculateFileHash(docFile);
                if (docFile.length() <= (long)((PushOptions)this.getOpts()).getChunkSize()) {
                    log.info("    transmitting file [{}] as single chunk", (Object)docFile.getAbsolutePath());
                    try (FileInputStream fileStream = new FileInputStream(docFile);){
                        DocumentFileUploadForm uploadForm = this.generateUploadForm(true, true, fileType, md5hash, docFile.length(), fileStream);
                        this.uploadDocumentPart(docId, locale, uploadForm);
                        break block29;
                    }
                }
                try (StreamChunker chunker = new StreamChunker(docFile, ((PushOptions)this.getOpts()).getChunkSize());){
                    log.info("    transmitting file [{}] as {} chunks", (Object)docFile.getAbsolutePath(), (Object)chunker.totalChunks());
                    Long uploadId = null;
                    for (InputStream chunkStream : chunker) {
                        log.info("        pushing chunk {} of {}", (Object)chunker.currentChunkNumber(), (Object)chunker.totalChunks());
                        boolean isFirst = chunker.currentChunkNumber() == 1;
                        boolean isLast = chunker.getRemainingChunks() == 0;
                        long chunkSize = chunker.currentChunkSize();
                        DocumentFileUploadForm uploadForm = this.generateUploadForm(isFirst, isLast, fileType, md5hash, chunkSize, chunkStream);
                        if (!isFirst) {
                            uploadForm.setUploadId(uploadId);
                        }
                        ChunkUploadResponse uploadResponse = this.uploadDocumentPart(docId, locale, uploadForm);
                        if (!isFirst || (uploadId = uploadResponse.getUploadId()) != null) continue;
                        throw new RuntimeException("server did not return upload id");
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private DocumentFileUploadForm generateUploadForm(boolean isFirst, boolean isLast, String fileType, String md5hash, long streamSize, InputStream fileStream) {
        DocumentFileUploadForm uploadForm = new DocumentFileUploadForm();
        uploadForm.setFirst(Boolean.valueOf(isFirst));
        uploadForm.setLast(Boolean.valueOf(isLast));
        uploadForm.setFileType(fileType);
        uploadForm.setHash(md5hash);
        uploadForm.setSize(Long.valueOf(streamSize));
        uploadForm.setFileStream(fileStream);
        return uploadForm;
    }

    private ChunkUploadResponse uploadDocumentPart(String docName, String locale, DocumentFileUploadForm uploadForm) {
        ConsoleUtils.startProgressFeedback();
        ChunkUploadResponse response = locale == null ? this.client.uploadSourceFile(((PushOptions)this.getOpts()).getProj(), ((PushOptions)this.getOpts()).getProjectVersion(), docName, uploadForm) : this.client.uploadTranslationFile(((PushOptions)this.getOpts()).getProj(), ((PushOptions)this.getOpts()).getProjectVersion(), locale, docName, ((PushOptions)this.getOpts()).getMergeType(), uploadForm);
        log.debug("response from server: {}", (Object)response);
        ConsoleUtils.endProgressFeedback();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calculateFileHash(File srcFile) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (InputStream fileStream = new FileInputStream(srcFile);){
                fileStream = new DigestInputStream(fileStream, md);
                byte[] buffer = new byte[256];
                while (fileStream.read(buffer) > 0) {
                }
            }
            String md5hash = new String(Hex.encodeHex((byte[])md.digest()));
            return md5hash;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static class StreamChunker
    implements Iterable<InputStream>,
    Closeable {
        private int totalChunkCount;
        private int chunksRetrieved;
        private File file;
        private byte[] buffer;
        private InputStream fileStream;
        private int actualChunkSize;

        public StreamChunker(File file, int chunkSize) throws FileNotFoundException {
            this.file = file;
            this.buffer = new byte[chunkSize];
            this.chunksRetrieved = 0;
            this.totalChunkCount = (int)(file.length() / (long)chunkSize + (long)(file.length() % (long)chunkSize == 0L ? 0 : 1));
            this.fileStream = new FileInputStream(file);
        }

        @Override
        public void close() throws IOException {
            this.fileStream.close();
        }

        public int totalChunks() {
            return this.totalChunkCount;
        }

        public int currentChunkNumber() {
            return this.chunksRetrieved;
        }

        public int currentChunkSize() {
            return this.actualChunkSize;
        }

        public int getRemainingChunks() {
            return this.totalChunkCount - this.chunksRetrieved;
        }

        private InputStream getNextChunk() {
            try {
                this.actualChunkSize = this.fileStream.read(this.buffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++this.chunksRetrieved;
            if (this.chunksRetrieved == this.totalChunkCount) {
                try {
                    this.fileStream.close();
                }
                catch (IOException e) {
                    log.error("failed to close input stream for file " + this.file.getAbsolutePath(), (Throwable)e);
                }
                this.fileStream = null;
            }
            return new ByteArrayInputStream(this.buffer, 0, this.actualChunkSize);
        }

        @Override
        public Iterator<InputStream> iterator() {
            return new Iterator<InputStream>(){

                @Override
                public boolean hasNext() {
                    return chunksRetrieved < totalChunkCount;
                }

                @Override
                public InputStream next() {
                    if (this.hasNext()) {
                        return this.getNextChunk();
                    }
                    throw new NoSuchElementException("getNextChunk() must not be called after all chunks have been retrieved");
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

