/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;

public class VersionComparator
implements Comparator<String> {
    private static final Splitter splitter = Splitter.on((String)".").omitEmptyStrings().trimResults();
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";

    @Override
    public int compare(String left, String right) {
        Preconditions.checkNotNull((Object)left);
        Preconditions.checkNotNull((Object)right);
        ImmutableList leftOrdinals = ImmutableList.copyOf((Iterable)splitter.split((CharSequence)left.replace(SNAPSHOT_SUFFIX, "")));
        ImmutableList rightOrdinals = ImmutableList.copyOf((Iterable)splitter.split((CharSequence)right.replace(SNAPSHOT_SUFFIX, "")));
        int compareIndex = VersionComparator.firstDiffOrdinalOrLastOrdinalInShortestVer((List<String>)leftOrdinals, (List<String>)rightOrdinals);
        if (compareIndex < leftOrdinals.size() && compareIndex < rightOrdinals.size()) {
            Integer rightOrdinal;
            Integer leftOrdinal = VersionComparator.getOrdinalAsInteger((List<String>)leftOrdinals, compareIndex);
            int ordinalDiff = leftOrdinal.compareTo(rightOrdinal = VersionComparator.getOrdinalAsInteger((List<String>)rightOrdinals, compareIndex));
            if (ordinalDiff == 0) {
                return VersionComparator.compareSnapshot(left, right);
            }
            return ordinalDiff;
        }
        int sizeDiff = leftOrdinals.size() - rightOrdinals.size();
        if (sizeDiff == 0) {
            return VersionComparator.compareSnapshot(left, right);
        }
        return Integer.signum(sizeDiff);
    }

    private static int firstDiffOrdinalOrLastOrdinalInShortestVer(List<String> leftOrdinals, List<String> rightOrdinals) {
        int result;
        for (result = 0; result < leftOrdinals.size() && result < rightOrdinals.size() && leftOrdinals.get(result).equals(rightOrdinals.get(result)); ++result) {
        }
        return result;
    }

    private static Integer getOrdinalAsInteger(List<String> ordinals, int index) {
        return Integer.valueOf(ordinals.get(index));
    }

    private static int compareSnapshot(String left, String right) {
        boolean leftIsSnapshot = left.endsWith(SNAPSHOT_SUFFIX);
        boolean rightIsSnapshot = right.endsWith(SNAPSHOT_SUFFIX);
        if (leftIsSnapshot && !rightIsSnapshot) {
            return -1;
        }
        if (!leftIsSnapshot && rightIsSnapshot) {
            return 1;
        }
        return 0;
    }
}

