/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.base.Strings;
import org.zanata.client.commands.Messages;

public interface ConsoleInteractor {
    public void expectYes();

    public String expectAnswerWithRetry(AnswerValidator var1);

    public ConsoleInteractor printf(String var1, Object ... var2);

    public ConsoleInteractor printfln(String var1, Object ... var2);

    public ConsoleInteractor printf(DisplayMode var1, String var2, Object ... var3);

    public ConsoleInteractor printfln(DisplayMode var1, String var2, Object ... var3);

    public String expectAnyNotBlankAnswer();

    public String expectAnyAnswer();

    public void blankLine();

    public static enum DisplayMode {
        Hint,
        Warning,
        Confirmation,
        Question,
        Information;

    }

    public static interface AnswerValidator {
        public static final AnswerValidator YES_NO = new AnswerValidator(){

            @Override
            public boolean isAnswerValid(String answer) {
                return answer.equalsIgnoreCase("y") || answer.equalsIgnoreCase("n") || answer.equalsIgnoreCase("yes") || answer.equalsIgnoreCase("no");
            }

            @Override
            public String invalidErrorMessage(String answer) {
                return String.format(Messages.get("expected.and.actual.answer"), "y or n", answer);
            }
        };
        public static final AnswerValidator NOT_BLANK = new AnswerValidator(){

            @Override
            public boolean isAnswerValid(String answer) {
                return !Strings.isNullOrEmpty((String)answer);
            }

            @Override
            public String invalidErrorMessage(String answer) {
                return Messages.get("no.blank.answer");
            }
        };
        public static final AnswerValidator ANY = new AnswerValidator(){

            @Override
            public boolean isAnswerValid(String answer) {
                return true;
            }

            @Override
            public String invalidErrorMessage(String answer) {
                throw new UnsupportedOperationException("any answer can not be invalid");
            }
        };

        public boolean isAnswerValid(String var1);

        public String invalidErrorMessage(String var1);
    }
}

