/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.PutVersionOptions;
import org.zanata.common.EntityStatus;
import org.zanata.rest.client.ProjectIterationClient;
import org.zanata.rest.dto.ProjectIteration;

public class PutVersionCommand
extends ConfigurableCommand<PutVersionOptions> {
    private static final Logger log = LoggerFactory.getLogger(PutVersionCommand.class);

    public PutVersionCommand(PutVersionOptions opts) {
        super(opts);
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void run() throws Exception {
        ProjectIteration version = new ProjectIteration();
        version.setId(((PutVersionOptions)this.getOpts()).getVersionSlug());
        version.setStatus(this.statusFromString(((PutVersionOptions)this.getOpts()).getVersionStatus()));
        if (((PutVersionOptions)this.getOpts()).getProjectType() != null) {
            if (StringUtils.isBlank((CharSequence)((PutVersionOptions)this.getOpts()).getProjectType())) {
                throw new Exception("If a project type is specified, it must not be empty.");
            }
            version.setProjectType(((PutVersionOptions)this.getOpts()).getProjectType());
        }
        log.debug("{}", (Object)version);
        ProjectIterationClient client = this.getClientFactory().getProjectIterationClient(((PutVersionOptions)this.getOpts()).getVersionProject(), ((PutVersionOptions)this.getOpts()).getVersionSlug());
        client.put(version);
    }

    private EntityStatus statusFromString(String status) throws Exception {
        if (status == null) {
            return null;
        }
        switch (status.toLowerCase()) {
            case "active": {
                return EntityStatus.ACTIVE;
            }
            case "readonly": {
                return EntityStatus.READONLY;
            }
        }
        throw new Exception("version-status can only be active or readonly");
    }
}

