/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.init.InitCommand;
import org.zanata.client.commands.init.InitOptions;
import org.zanata.client.commands.init.ProjectPrompt;
import org.zanata.common.EntityStatus;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.Project;
import org.zanata.rest.dto.ProjectIteration;

class ProjectIterationPrompt {
    private final ConsoleInteractor consoleInteractor;
    private final InitOptions opts;
    private final RestClientFactory clientFactory;

    ProjectIterationPrompt(ConsoleInteractor consoleInteractor, InitOptions opts, RestClientFactory clientFactory) {
        this.consoleInteractor = consoleInteractor;
        this.opts = opts;
        this.clientFactory = clientFactory;
    }

    public void selectOrCreateNewVersion() {
        this.consoleInteractor.printfln(Messages.get("do.you.want.to"), new Object[0]);
        this.consoleInteractor.printf("1)", new Object[0]).printfln(ConsoleInteractor.DisplayMode.Hint, Messages.get("project.version.select"), new Object[0]);
        this.consoleInteractor.printf("2)", new Object[0]).printfln(ConsoleInteractor.DisplayMode.Hint, Messages.get("project.version.create"), new Object[0]);
        this.consoleInteractor.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("select.or.create"), new Object[0]);
        String answer = this.consoleInteractor.expectAnswerWithRetry(ConsoleInteractorImpl.AnswerValidatorImpl.expect("1", "2"));
        if (answer.equals("1")) {
            this.selectVersion();
        } else {
            this.createNewVersion();
        }
    }

    @VisibleForTesting
    protected void selectVersion() {
        Project project = this.clientFactory.getProjectClient(this.opts.getProj()).get();
        this.consoleInteractor.printfln(Messages.get("available.versions"), project.getName());
        int oneBasedIndex = 1;
        ArrayList versionIndexes = Lists.newArrayList();
        Iterable activeIterations = Iterables.filter((Iterable)project.getIterations(), (Predicate)new ActiveIterationPredicate());
        for (ProjectIteration iteration : activeIterations) {
            versionIndexes.add(oneBasedIndex + "");
            this.consoleInteractor.printf("%d)", oneBasedIndex).printfln(ConsoleInteractor.DisplayMode.Hint, iteration.getId(), new Object[0]);
            ++oneBasedIndex;
        }
        this.consoleInteractor.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("select.version.prompt"), new Object[0]);
        String selection = this.consoleInteractor.expectAnswerWithRetry(ConsoleInteractorImpl.AnswerValidatorImpl.expect(versionIndexes));
        ProjectIteration projectIteration = (ProjectIteration)Iterables.get((Iterable)activeIterations, (int)(Integer.parseInt(selection) - 1));
        String versionId = projectIteration.getId();
        this.opts.setProjectVersion(versionId);
        this.opts.setProjectType(this.resolveProjectType(project, projectIteration));
    }

    private String resolveProjectType(Project project, ProjectIteration projectIteration) {
        if (!Strings.isNullOrEmpty((String)projectIteration.getProjectType())) {
            return projectIteration.getProjectType().toLowerCase();
        }
        if (!Strings.isNullOrEmpty((String)project.getDefaultType())) {
            return project.getDefaultType().toLowerCase();
        }
        String projectTypes = Joiner.on((String)", ").join(ProjectPrompt.PROJECT_TYPE_LIST);
        this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Question, Messages.get("project.type.prompt"), projectTypes);
        return this.consoleInteractor.expectAnswerWithRetry(ConsoleInteractorImpl.AnswerValidatorImpl.expect(ProjectPrompt.PROJECT_TYPE_LIST));
    }

    @VisibleForTesting
    protected void createNewVersion() {
        this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Question, Messages.get("project.version.id.prompt"), new Object[0]);
        String versionId = this.consoleInteractor.expectAnyAnswer();
        ProjectIteration iteration = new ProjectIteration(versionId);
        iteration.setProjectType(this.opts.getProjectType());
        try {
            this.clientFactory.getProjectIterationClient(this.opts.getProj(), versionId).put(iteration);
        }
        catch (Exception ex) {
            InitCommand.offerRetryOnServerError(ex, this.consoleInteractor);
            this.createNewVersion();
        }
        this.opts.setProjectVersion(versionId);
        this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Confirmation, Messages.get("project.version.created"), new Object[0]);
    }

    private static class ActiveIterationPredicate
    implements Predicate<ProjectIteration> {
        private ActiveIterationPredicate() {
        }

        public boolean apply(ProjectIteration input) {
            return input.getStatus() == EntityStatus.ACTIVE;
        }
    }
}

