/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;

public class FileUtil {
    public static String simplifyPath(String pathname) {
        Preconditions.checkNotNull((Object)pathname);
        if (pathname.length() == 0) {
            return ".";
        }
        Iterable components = Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)pathname);
        ArrayList<String> path = new ArrayList<String>();
        for (String component : components) {
            if (component.equals(".")) continue;
            if (component.equals("..")) {
                if (path.size() > 0 && !((String)path.get(path.size() - 1)).equals("..")) {
                    path.remove(path.size() - 1);
                    continue;
                }
                path.add("..");
                continue;
            }
            path.add(component);
        }
        String result = Joiner.on((char)'/').join(path);
        if (pathname.charAt(0) == '/') {
            result = "/" + result;
        }
        while (result.startsWith("/../")) {
            result = result.substring(3);
        }
        if (result.equals("/..")) {
            result = "/";
        } else if ("".equals(result)) {
            result = ".";
        }
        return result;
    }
}

