/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
public class ApiKeyHeaderFilter
extends ClientFilter {
    private String apiKey;
    private String username;
    private String ver;

    public ApiKeyHeaderFilter(String username, String apiKey, String ver) {
        this.username = username;
        this.apiKey = apiKey;
        this.ver = ver;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        MultivaluedMap headers = cr.getHeaders();
        headers.add((Object)"X-Auth-User", (Object)this.username);
        headers.add((Object)"X-Auth-Token", (Object)this.apiKey);
        headers.add((Object)"X-Version-No", (Object)this.ver);
        return this.handleNext(cr);
    }

    @VisibleForTesting
    protected ClientResponse handleNext(ClientRequest cr) {
        return this.getNext().handle(cr);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

