/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.DefaultValue;
import org.zanata.common.LocaleId;
import org.zanata.rest.client.CacheResponseFilter;
import org.zanata.rest.client.ClientUtil;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.ProcessStatus;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.rest.service.AsynchronousProcessResource;

public class AsyncProcessClient
implements AsynchronousProcessResource {
    private final RestClientFactory factory;
    private final URI baseUri;

    AsyncProcessClient(RestClientFactory factory) {
        this.factory = factory;
        this.baseUri = factory.getBaseUri();
    }

    public ProcessStatus startSourceDocCreation(String idNoSlash, String projectSlug, String iterationSlug, Resource resource, Set<String> extensions, @DefaultValue(value="true") boolean copytrans) {
        throw new UnsupportedOperationException("Not supported. Use startSourceDocCreationOrUpdate instead.");
    }

    public ProcessStatus startSourceDocCreationOrUpdate(String idNoSlash, String projectSlug, String iterationSlug, Resource resource, Set<String> extensions, @DefaultValue(value="true") boolean copytrans) {
        Client client = this.factory.getClient();
        CacheResponseFilter filter = new CacheResponseFilter();
        client.addFilter((ClientFilter)filter);
        WebResource webResource = client.resource(this.baseUri).path("/async").path("projects").path("p").path(projectSlug).path("iterations").path("i").path(iterationSlug).path("r").path(idNoSlash);
        webResource.queryParams(ClientUtil.asMultivaluedMap("ext", extensions)).queryParam("copyTrans", String.valueOf(copytrans)).put((Object)resource);
        client.removeFilter((ClientFilter)filter);
        return filter.getEntity(ProcessStatus.class);
    }

    public ProcessStatus startTranslatedDocCreationOrUpdate(String idNoSlash, String projectSlug, String iterationSlug, LocaleId locale, TranslationsResource translatedDoc, Set<String> extensions, String merge, @DefaultValue(value="false") boolean myTrans) {
        Client client = this.factory.getClient();
        CacheResponseFilter filter = new CacheResponseFilter();
        client.addFilter((ClientFilter)filter);
        WebResource webResource = client.resource(this.baseUri).path("/async").path("projects").path("p").path(projectSlug).path("iterations").path("i").path(iterationSlug).path("r").path(idNoSlash).path("translations").path(locale.toString());
        webResource.queryParams(ClientUtil.asMultivaluedMap("ext", extensions)).queryParam("merge", merge).queryParam("assignCreditToUploader", String.valueOf(myTrans)).put((Object)translatedDoc);
        client.removeFilter((ClientFilter)filter);
        return filter.getEntity(ProcessStatus.class);
    }

    public ProcessStatus getProcessStatus(String processId) {
        return (ProcessStatus)this.factory.getClient().resource(this.baseUri).path("/async").path(processId).get(ProcessStatus.class);
    }
}

