/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.google.common.base.Strings;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

public class ClientUtil {
    static MultivaluedMap<String, String> asMultivaluedMap(String paramKey, Iterable<String> values) {
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (values == null) {
            return map;
        }
        for (String extension : values) {
            map.add(paramKey, extension);
        }
        return map;
    }

    public static void checkResult(ClientResponse response) {
        ClientResponse.Status responseStatus = response.getClientResponseStatus();
        int statusCode = response.getStatus();
        if (responseStatus == ClientResponse.Status.UNAUTHORIZED) {
            throw new RuntimeException("Incorrect username/password");
        }
        if (responseStatus == ClientResponse.Status.SERVICE_UNAVAILABLE) {
            throw new RuntimeException("Service is currently unavailable. Please check outage notification or try again later.");
        }
        if (responseStatus == ClientResponse.Status.MOVED_PERMANENTLY || statusCode == 302) {
            String message;
            String movedTo = (String)response.getHeaders().getFirst((Object)"Location");
            if (!Strings.isNullOrEmpty((String)movedTo)) {
                String baseUrl = ClientUtil.getBaseURL(movedTo);
                message = "Server returned a redirect to:" + baseUrl + ". You must change your url option or config file.";
            } else {
                message = "Server returned a redirect. You must change your url option or config file.";
            }
            throw new RuntimeException(message);
        }
        if (statusCode >= 399) {
            String annotString = "";
            String uriString = "";
            String entity = "";
            entity = ": " + (String)response.getEntity(String.class);
            String msg = "operation returned " + statusCode + " (" + Response.Status.fromStatusCode((int)statusCode) + ")" + entity + uriString + annotString;
            throw new RuntimeException(msg);
        }
    }

    public static String getBaseURL(String movedTo) {
        try {
            URL url = new URI(movedTo).toURL();
            int pathIndex = movedTo.lastIndexOf(url.getPath());
            return movedTo.substring(0, pathIndex) + "/";
        }
        catch (MalformedURLException | URISyntaxException e) {
            return movedTo;
        }
    }

    public static String getFileNameFromHeader(MultivaluedMap<String, String> headers) {
        String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
        String FILENAME_PATTERN = "filename=\"(.*?)\"$";
        String contentDisposition = (String)headers.getFirst((Object)"Content-Disposition");
        if (StringUtils.isEmpty((String)contentDisposition)) {
            return null;
        }
        Pattern p = Pattern.compile("filename=\"(.*?)\"$");
        Matcher m = p.matcher(contentDisposition);
        return m.find() ? m.group(1) : null;
    }
}

