/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.zanata.rest.client.CacheResponseFilter;
import org.zanata.rest.client.ClientUtil;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;

public class SourceDocResourceClient {
    private final RestClientFactory factory;
    private final String project;
    private final String projectVersion;
    private final URI baseUri;

    SourceDocResourceClient(RestClientFactory factory, String project, String projectVersion) {
        this.factory = factory;
        this.project = project;
        this.projectVersion = projectVersion;
        this.baseUri = factory.getBaseUri();
    }

    public List<ResourceMeta> getResourceMeta(Set<String> extensions) {
        Client client = this.factory.getClient();
        WebResource webResource = this.getBaseServiceResource(client).queryParams(ClientUtil.asMultivaluedMap("ext", extensions));
        return (List)webResource.get((GenericType)new GenericType<List<ResourceMeta>>(){});
    }

    private WebResource getBaseServiceResource(Client client) {
        return client.resource(this.baseUri).path("projects").path("p").path(this.project).path("iterations").path("i").path(this.projectVersion).path("r");
    }

    public Resource getResource(String idNoSlash, Set<String> extensions) {
        Client client = this.factory.getClient();
        WebResource webResource = this.getBaseServiceResource(client).path(idNoSlash).queryParams(ClientUtil.asMultivaluedMap("ext", extensions));
        return (Resource)webResource.get(Resource.class);
    }

    public String putResource(String idNoSlash, Resource resource, Set<String> extensions, boolean copyTrans) {
        Client client = this.factory.getClient();
        CacheResponseFilter filter = new CacheResponseFilter();
        client.addFilter((ClientFilter)filter);
        WebResource webResource = this.getBaseServiceResource(client).path(idNoSlash).queryParams(ClientUtil.asMultivaluedMap("ext", extensions)).queryParam("copyTrans", String.valueOf(copyTrans));
        webResource.put((Object)resource);
        client.removeFilter((ClientFilter)filter);
        return filter.getEntity(String.class);
    }

    public String deleteResource(String idNoSlash) {
        Client client = this.factory.getClient();
        WebResource webResource = this.getBaseServiceResource(client);
        return (String)webResource.path(idNoSlash).delete(String.class);
    }
}

