/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.google.common.collect.Lists;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DefaultValue;
import org.zanata.rest.client.ClientUtil;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.stats.ContainerTranslationStatistics;
import org.zanata.rest.dto.stats.contribution.ContributionStatistics;
import org.zanata.rest.service.StatisticsResource;

public class StatisticsResourceClient
implements StatisticsResource {
    private final RestClientFactory factory;
    private final URI baseUri;

    StatisticsResourceClient(RestClientFactory factory) {
        this.factory = factory;
        this.baseUri = factory.getBaseUri();
    }

    public ContainerTranslationStatistics getStatistics(String projectSlug, String iterationSlug, @DefaultValue(value="false") boolean includeDetails, @DefaultValue(value="false") boolean includeWordStats, String[] locales) {
        WebResource webResource = this.factory.getClient().resource(this.baseUri).path("stats").path("proj").path(projectSlug).path("iter").path(iterationSlug).queryParam("detail", String.valueOf(includeDetails)).queryParam("word", String.valueOf(includeWordStats)).queryParams(ClientUtil.asMultivaluedMap("locale", StatisticsResourceClient.toLocaleList(locales)));
        return (ContainerTranslationStatistics)webResource.get(ContainerTranslationStatistics.class);
    }

    private static List<String> toLocaleList(String[] locales) {
        ArrayList localesList = locales == null ? Lists.newArrayList() : Lists.newArrayList((Object[])locales);
        return localesList;
    }

    public ContainerTranslationStatistics getStatistics(String projectSlug, String iterationSlug, String docId, @DefaultValue(value="false") boolean includeWordStats, String[] locales) {
        WebResource webResource = this.factory.getClient().resource(this.baseUri).path("stats").path("proj").path(projectSlug).path("iter").path(iterationSlug).path("doc").path(docId).queryParam("word", String.valueOf(includeWordStats)).queryParams(ClientUtil.asMultivaluedMap("locale", StatisticsResourceClient.toLocaleList(locales)));
        return (ContainerTranslationStatistics)webResource.get(ContainerTranslationStatistics.class);
    }

    public ContributionStatistics getContributionStatistics(String projectSlug, String versionSlug, String username, String dateRange, boolean includeAutomatedEntry) {
        WebResource webResource = this.factory.getClient().resource(this.baseUri).path("stats").path("project").path(projectSlug).path("version").path(versionSlug).path("contributor").path(username).path(dateRange).queryParam("includeAutomatedEntry", String.valueOf(includeAutomatedEntry));
        return (ContributionStatistics)webResource.get(ContributionStatistics.class);
    }
}

