/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.google.common.base.Charsets;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class TraceDebugFilter
extends ClientFilter {
    private static final Logger log = LoggerFactory.getLogger(TraceDebugFilter.class);
    private boolean logHttp;

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        if (!this.logHttp && !log.isTraceEnabled()) {
            return this.getNext().handle(cr);
        }
        this.log(">> REST Request: " + cr.getMethod() + " => " + cr.getURI());
        for (String key : cr.getHeaders().keySet()) {
            String headerVal = ((List)cr.getHeaders().get((Object)key)).toString();
            if (key.equals("X-Auth-Token")) {
                headerVal = this.maskHeaderValues((List)cr.getHeaders().get((Object)key));
            }
            this.log(">> Header: " + key + " = " + headerVal);
        }
        this.log(">> body: " + cr.getEntity());
        ClientResponse response = this.getNext().handle(cr);
        this.log("<< REST Response: " + response.getStatus() + ":" + response.getClientResponseStatus());
        for (String key : response.getHeaders().keySet()) {
            this.log("<< Header: " + key + " = " + response.getHeaders().get((Object)key));
        }
        response.bufferEntity();
        this.log(">> Body: " + this.getPayloadAsString(response));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPayloadAsString(ClientResponse response) {
        ByteArrayInputStream entityInputStream = null;
        try {
            entityInputStream = (ByteArrayInputStream)response.getEntityInputStream();
            int available = entityInputStream.available();
            byte[] data = new byte[available];
            entityInputStream.read(data);
            String string = new String(data, 0, available, Charsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            log.warn("can't read response payload");
            String string = "[error reading response]";
            return string;
        }
        finally {
            if (entityInputStream != null) {
                entityInputStream.reset();
            }
        }
    }

    public TraceDebugFilter(boolean logHttp) {
        this.logHttp = logHttp;
    }

    private void log(String msg) {
        if (this.logHttp) {
            log.info(msg);
        } else {
            log.trace(msg);
        }
    }

    private String maskHeaderValues(List<Object> headerValues) {
        ArrayList<String> maskedList = new ArrayList<String>(headerValues.size());
        for (Object actualValue : headerValues) {
            maskedList.add(actualValue.toString().replaceAll(".", "*"));
        }
        return ((Object)maskedList).toString();
    }
}

