/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.zanata.common.LocaleId;
import org.zanata.rest.client.ClientUtil;
import org.zanata.rest.client.RestClientFactory;

public class TransDocResourceClient {
    private final RestClientFactory factory;
    private final String project;
    private final String projectVersion;
    private final URI baseUri;

    TransDocResourceClient(RestClientFactory factory, String project, String projectVersion) {
        this.factory = factory;
        this.project = project;
        this.projectVersion = projectVersion;
        this.baseUri = factory.getBaseUri();
    }

    public ClientResponse getTranslations(@PathParam(value="id") String idNoSlash, @PathParam(value="locale") LocaleId locale, @QueryParam(value="ext") Set<String> extensions, @QueryParam(value="skeletons") boolean createSkeletons, @HeaderParam(value="If-None-Match") String eTag) {
        Client client = this.factory.getClient();
        return (ClientResponse)this.getBaseServiceResource(client).path(idNoSlash).path("translations").path(locale.getId()).queryParams(ClientUtil.asMultivaluedMap("ext", extensions)).queryParam("skeletons", String.valueOf(createSkeletons)).header("If-None-Match", (Object)eTag).get(ClientResponse.class);
    }

    private WebResource getBaseServiceResource(Client client) {
        return client.resource(this.baseUri).path("projects").path("p").path(this.project).path("iterations").path("i").path(this.projectVersion).path("r");
    }
}

