/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;

public class ClientUtil {
    public static String getBaseURL(String movedTo) {
        try {
            URL url = new URI(movedTo).toURL();
            int pathIndex = movedTo.lastIndexOf(url.getPath());
            return movedTo.substring(0, pathIndex) + "/";
        }
        catch (MalformedURLException | URISyntaxException e) {
            return movedTo;
        }
    }

    public static String getFileNameFromHeader(MultivaluedMap<String, String> headers) {
        String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
        String FILENAME_PATTERN = "filename=\"(.*?)\"$";
        String contentDisposition = (String)headers.getFirst((Object)"Content-Disposition");
        if (StringUtils.isEmpty((CharSequence)contentDisposition)) {
            return null;
        }
        Pattern p = Pattern.compile("filename=\"(.*?)\"$");
        Matcher m = p.matcher(contentDisposition);
        return m.find() ? m.group(1) : null;
    }
}

