/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.rest.client.AccountClient;
import org.zanata.rest.client.ApiKeyHeaderFilter;
import org.zanata.rest.client.AsyncProcessClient;
import org.zanata.rest.client.CopyTransClient;
import org.zanata.rest.client.FileResourceClient;
import org.zanata.rest.client.GlossaryClient;
import org.zanata.rest.client.InvalidContentTypeFilter;
import org.zanata.rest.client.ProjectClient;
import org.zanata.rest.client.ProjectIterationClient;
import org.zanata.rest.client.ProjectIterationLocalesClient;
import org.zanata.rest.client.ProjectsClient;
import org.zanata.rest.client.RedirectFilter;
import org.zanata.rest.client.ResponseStatusFilter;
import org.zanata.rest.client.SourceDocResourceClient;
import org.zanata.rest.client.StatisticsResourceClient;
import org.zanata.rest.client.TraceDebugFilter;
import org.zanata.rest.client.TransDocResourceClient;
import org.zanata.rest.dto.VersionInfo;

public class RestClientFactory
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RestClientFactory.class);
    private static final long serialVersionUID = -276490112687360482L;
    private String serverVersion;
    private String clientVersion;
    private VersionInfo clientApiVersion;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private Client client;
    private URI baseURI;

    protected RestClientFactory() {
    }

    public RestClientFactory(URI base, String username, String apiKey, VersionInfo clientApiVersion, boolean logHttp, boolean sslCertDisabled) {
        this.baseURI = base;
        this.clientApiVersion = clientApiVersion;
        this.clientVersion = clientApiVersion.getVersionNo();
        this.client = new ResteasyClientBuilder().sslContext(RestClientFactory.sslConfiguration(sslCertDisabled)).register((Object)new RedirectFilter()).register((Object)new ResponseStatusFilter()).register((Object)new ApiKeyHeaderFilter(username, apiKey, this.clientVersion)).register((Object)new TraceDebugFilter(logHttp)).register((Object)new InvalidContentTypeFilter()).build();
    }

    public RestClientFactory(URI base, String username, String apiKey, VersionInfo clientApiVersion, boolean logHttp, boolean sslCertDisabled, Consumer<ResteasyClientBuilder> resteasyClientBuilderModifier) {
        this.baseURI = base;
        this.clientApiVersion = clientApiVersion;
        this.clientVersion = clientApiVersion.getVersionNo();
        ResteasyClientBuilder clientBuilder = new ResteasyClientBuilder().sslContext(RestClientFactory.sslConfiguration(sslCertDisabled)).register((Object)new RedirectFilter()).register((Object)new ResponseStatusFilter()).register((Object)new ApiKeyHeaderFilter(username, apiKey, this.clientVersion)).register((Object)new TraceDebugFilter(logHttp)).register((Object)new InvalidContentTypeFilter());
        resteasyClientBuilderModifier.accept(clientBuilder);
        this.client = clientBuilder.build();
    }

    private static SSLContext sslConfiguration(boolean sslCertDisabled) {
        if (!sslCertDisabled) {
            return null;
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustAllCerts = new TrustManager[]{new AcceptAllX509TrustManager()};
            sslContext.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            return sslContext;
        }
        catch (Exception e) {
            log.warn("error creating SSL client", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public VersionInfo getServerVersionInfo() {
        return (VersionInfo)this.client.target(this.getBaseUri()).path("version").request(new String[]{"application/vnd.zanata.Version+xml"}).get(VersionInfo.class);
    }

    public void performVersionCheck() {
        this.clientVersion = this.clientApiVersion.getVersionNo();
        String clientScm = this.clientApiVersion.getScmDescribe();
        VersionInfo serverVersionInfo = this.getServerVersionInfo();
        this.serverVersion = serverVersionInfo.getVersionNo();
        String serverScm = serverVersionInfo.getScmDescribe();
        log.info("client API version: {}, server API version: {}", (Object)this.clientVersion, (Object)this.serverVersion);
        this.warnMismatchAPIVersion(clientScm, serverScm);
    }

    private void warnMismatchAPIVersion(String clientScm, String serverScm) {
        if (!this.serverVersion.equals(this.clientVersion)) {
            log.warn("client API version is {}, but server API version is {}", (Object)this.clientVersion, (Object)this.serverVersion);
        } else if (this.serverVersion.contains("SNAPSHOT") && !serverScm.equalsIgnoreCase(clientScm)) {
            log.warn("client API SCM id is {}, but server API SCM id is {}", (Object)clientScm, (Object)serverScm);
        }
    }

    private URL getBaseUrl() {
        try {
            return new URL(RestClientFactory.fixBase(this.baseURI).toString() + this.getUrlPrefix());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected URI getBaseUri() {
        try {
            return this.getBaseUrl().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static URI fixBase(URI base) {
        String baseString;
        if (base != null && !(baseString = base.toString()).endsWith("/")) {
            try {
                URI result = new URI(baseString + "/");
                log.warn("Appending '/' to base URL '{}': using '{}'", (Object)baseString, (Object)result);
                return result;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return base;
    }

    protected String getUrlPrefix() {
        return "rest/";
    }

    protected Client getClient() {
        return this.client;
    }

    public int compareToServerVersion(String version) {
        DefaultArtifactVersion srvVersion = new DefaultArtifactVersion(this.serverVersion);
        DefaultArtifactVersion providedVersion = new DefaultArtifactVersion(version);
        return srvVersion.compareTo((ArtifactVersion)providedVersion);
    }

    public AccountClient getAccountClient() {
        return new AccountClient(this);
    }

    public AsyncProcessClient getAsyncProcessClient() {
        return new AsyncProcessClient(this);
    }

    public CopyTransClient getCopyTransClient() {
        return new CopyTransClient(this);
    }

    public FileResourceClient getFileResourceClient() {
        return new FileResourceClient(this);
    }

    public GlossaryClient getGlossaryClient() {
        return new GlossaryClient(this);
    }

    public ProjectClient getProjectClient(String projectSlug) {
        return new ProjectClient(this, projectSlug);
    }

    public ProjectIterationClient getProjectIterationClient(String projectSlug, String versionSlug) {
        return new ProjectIterationClient(this, projectSlug, versionSlug);
    }

    public ProjectsClient getProjectsClient() {
        return new ProjectsClient(this);
    }

    public SourceDocResourceClient getSourceDocResourceClient(String projectSlug, String versionSlug) {
        return new SourceDocResourceClient(this, projectSlug, versionSlug);
    }

    public StatisticsResourceClient getStatisticsClient() {
        return new StatisticsResourceClient(this);
    }

    public TransDocResourceClient getTransDocResourceClient(String projectSlug, String versionSlug) {
        return new TransDocResourceClient(this, projectSlug, versionSlug);
    }

    public ProjectIterationLocalesClient getProjectLocalesClient(String projectSlug, String versionSlug) {
        return new ProjectIterationLocalesClient(this, projectSlug, versionSlug);
    }

    private static class AcceptAllX509TrustManager
    implements X509TrustManager {
        private AcceptAllX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

