/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import java.net.URI;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.zanata.common.LocaleId;
import org.zanata.rest.RestUtil;
import org.zanata.rest.client.RestClientFactory;

public class TransDocResourceClient {
    private final RestClientFactory factory;
    private final String project;
    private final String projectVersion;
    private final URI baseUri;

    TransDocResourceClient(RestClientFactory factory, String project, String projectVersion) {
        this.factory = factory;
        this.project = project;
        this.projectVersion = projectVersion;
        this.baseUri = factory.getBaseUri();
    }

    public Response getTranslations(String docId, LocaleId locale, Set<String> extensions, boolean createSkeletons, String eTag) {
        Client client = this.factory.getClient();
        try {
            return this.getBaseServiceResource(client).path("resource").path("translations").path(locale.getId()).queryParam("docId", new Object[]{docId}).queryParam("ext", extensions.toArray()).queryParam("skeletons", new Object[]{String.valueOf(createSkeletons)}).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).header("If-None-Match", (Object)eTag).get();
        }
        catch (ResponseProcessingException e) {
            if (RestUtil.isNotFound((Response)e.getResponse())) {
                String idNoSlash = RestUtil.convertToDocumentURIId((String)docId);
                return this.getBaseServiceResource(client).path("r").path(idNoSlash).path("translations").path(locale.getId()).queryParam("ext", extensions.toArray()).queryParam("skeletons", new Object[]{String.valueOf(createSkeletons)}).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).header("If-None-Match", (Object)eTag).get();
            }
            throw e;
        }
    }

    private WebTarget getBaseServiceResource(Client client) {
        return client.target(this.baseUri).path("projects").path("p").path(this.project).path("iterations").path("i").path(this.projectVersion);
    }
}

