/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.util.Cache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMap<K, V>
implements Map<K, V>,
Cache<K, V>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 20070907L;
    private Map<K, Value<V>> _map;
    private int _lifetime = 1800000;
    private int _maxsize = 512;
    private transient ReferenceQueue<X> _que;
    private transient WeakReference<X> _ref;
    private transient boolean _inExpunge;
    private final boolean _accessOrder;
    protected static final int EXPUNGE_NO = 0;
    protected static final int EXPUNGE_YES = 1;
    protected static final int EXPUNGE_CONTINUE = 0;
    protected static final int EXPUNGE_STOP = 2;

    protected void onExpunge(Value<V> v) {
    }

    protected boolean shallExpunge() {
        return this._que == null || this._que.poll() != null;
    }

    protected int canExpunge(int size, Value<V> v) {
        return size > this.getMaxSize() || System.currentTimeMillis() - ((Value)v).access > (long)this.getLifetime() ? 1 : 2;
    }

    private void tryExpunge() {
        if (this.shallExpunge()) {
            this.doExpunge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doExpunge() {
        if (this._inExpunge) {
            throw new IllegalStateException("expunge in expunge?");
        }
        try {
            this.expunge();
        }
        finally {
            this.newRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int expunge() {
        if (this._inExpunge || this._map.isEmpty()) {
            return this._map.size();
        }
        this._inExpunge = true;
        try {
            int size = this._map.size();
            Iterator<Map.Entry<K, Value<V>>> it = this._map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<K, Value<V>> entry = it.next();
                Value<V> v = entry.getValue();
                int result = this.canExpunge(size, v);
                if ((result & 1) != 0) {
                    --size;
                    this.removeInExpunge(it, entry.getKey());
                    this.onExpunge(v);
                }
                if ((result & 2) == 0) continue;
                break;
            }
            int n = size;
            return n;
        }
        finally {
            this._inExpunge = false;
        }
    }

    void removeInExpunge(Iterator<Map.Entry<K, Value<V>>> it, K k) {
        it.remove();
    }

    private void newRef() {
        if (this._que != null) {
            this._ref = new WeakReference<X>(new X(), this._que);
        }
    }

    public CacheMap(int maxSize, int lifetime) {
        this(maxSize, lifetime, true);
    }

    public CacheMap() {
        this(16, 0.75f, true);
    }

    public CacheMap(int cap) {
        this(cap, 0.75f, true);
    }

    public CacheMap(int cap, float load) {
        this(cap, load, true);
    }

    public CacheMap(boolean accessOrder) {
        this(16, 0.75f, accessOrder);
    }

    public CacheMap(int maxSize, int lifetime, boolean accessOrder) {
        this(accessOrder);
        this.setMaxSize(maxSize);
        this.setLifetime(lifetime);
    }

    public CacheMap(int cap, float load, boolean accessOrder) {
        this._accessOrder = accessOrder;
        this._map = new LinkedHashMap<K, Value<V>>(cap, load, accessOrder);
        this.init();
    }

    private void init() {
        this._que = new ReferenceQueue();
        this.newRef();
    }

    @Override
    public int getLifetime() {
        return this._lifetime;
    }

    @Override
    public void setLifetime(int lifetime) {
        this._lifetime = lifetime;
    }

    @Override
    public int getMaxSize() {
        return this._maxsize;
    }

    @Override
    public void setMaxSize(int maxsize) {
        this._maxsize = maxsize;
    }

    @Override
    public boolean isEmpty() {
        this.tryExpunge();
        return this._map.isEmpty();
    }

    public boolean isEmptyWithoutExpunge() {
        return this._map.isEmpty();
    }

    @Override
    public int size() {
        this.tryExpunge();
        return this._map.size();
    }

    public int sizeWithoutExpunge() {
        return this._map.size();
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public V remove(Object key) {
        Value<V> v = this._map.remove(key);
        this.tryExpunge();
        return (V)(v != null ? ((Value)v).value : null);
    }

    @Override
    public V get(Object key) {
        V v = this.getWithoutExpunge(key);
        this.tryExpunge();
        return v;
    }

    public V getWithoutExpunge(Object key) {
        Value<V> v = this._map.get(key);
        if (v != null) {
            if (this._accessOrder) {
                ((Value)v).updateAccessTime();
            }
            return (V)((Value)v).value;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        this.tryExpunge();
        return this.containsKeyWithoutExpunge(key);
    }

    public boolean containsKeyWithoutExpunge(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.tryExpunge();
        for (Value<V> v : this._map.values()) {
            if (!Objects.equals(value, ((Value)v).value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        this.tryExpunge();
        Value v = this._map.put(key, new Value(value));
        return (V)(v != null ? v.value : null);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> me : map.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.tryExpunge();
        return new EntrySet();
    }

    @Override
    public Set<K> keySet() {
        this.tryExpunge();
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        this.tryExpunge();
        return new Values();
    }

    @Override
    public int hashCode() {
        this.tryExpunge();
        return ((Object)this._map).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        this.tryExpunge();
        return o == this || o instanceof CacheMap && ((Object)this._map).equals(((CacheMap)o)._map) || o instanceof Map && ((Object)this._map).equals(o);
    }

    public String toString() {
        this.tryExpunge();
        StringBuffer sb = new StringBuffer(128).append('{');
        if (!this._map.isEmpty()) {
            Iterator<Map.Entry<K, Value<V>>> it = this._map.entrySet().iterator();
            while (true) {
                Map.Entry<K, Value<V>> me = it.next();
                sb.append(me.getKey()).append('=').append(Objects.toString(((Value)me.getValue()).value));
                if (!it.hasNext()) break;
                sb.append(", ");
            }
        }
        return sb.append('}').toString();
    }

    public Object clone() {
        CacheMap clone;
        try {
            clone = (CacheMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._inExpunge = false;
        clone._map = new LinkedHashMap<K, Value<V>>(16, 0.75f, this._accessOrder);
        for (Map.Entry<K, Value<V>> me : this._map.entrySet()) {
            clone._map.put(me.getKey(), (Value)me.getValue().clone());
        }
        clone.init();
        return clone;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValueIter(CacheMap.this._map.values().iterator());
        }

        public int size() {
            return CacheMap.this.size();
        }

        public boolean contains(Object o) {
            return CacheMap.this.containsValue(o);
        }

        public void clear() {
            CacheMap.this.clear();
        }
    }

    private static class ValueIter
    extends KeyIter {
        private ValueIter(Iterator it) {
            super(it);
        }

        public Object next() {
            return ((Value)super.next()).value;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            CacheMap.this.tryExpunge();
            return new KeyIter(CacheMap.this._map.keySet().iterator());
        }

        public boolean contains(Object o) {
            return CacheMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return CacheMap.this.remove(o) != null;
        }

        public int size() {
            return CacheMap.this.size();
        }

        public void clear() {
            CacheMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            CacheMap.this.tryExpunge();
            return new EntryIter(CacheMap.this._map.entrySet().iterator());
        }

        public boolean contains(Object o) {
            return o instanceof Map.Entry && CacheMap.this.containsKey(((Map.Entry)o).getKey());
        }

        public boolean remove(Object o) {
            return o instanceof Map.Entry && CacheMap.this.remove(((Map.Entry)o).getKey()) != null;
        }

        public int size() {
            return CacheMap.this.size();
        }

        public void clear() {
            CacheMap.this.clear();
        }
    }

    private static class EntryIter
    extends KeyIter {
        private EntryIter(Iterator it) {
            super(it);
        }

        public Object next() {
            return new Entry((Map.Entry)super.next());
        }
    }

    private static class KeyIter
    implements Iterator {
        private Iterator _it;

        private KeyIter(Iterator it) {
            this._it = it;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public void remove() {
            this._it.remove();
        }

        public Object next() {
            return this._it.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        final Map.Entry<K, Value<V>> _me;

        private Entry(Map.Entry me) {
            this._me = me;
        }

        @Override
        public K getKey() {
            return this._me.getKey();
        }

        @Override
        public V getValue() {
            return (V)((Value)this._me.getValue()).value;
        }

        @Override
        public V setValue(V o) {
            Value<V> v = this._me.getValue();
            Object old = ((Value)v).value;
            ((Value)v).value = o;
            return (V)old;
        }

        @Override
        public int hashCode() {
            return ((Object)this._me).hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof Entry && ((Object)this._me).equals(((Entry)o)._me);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Value<V>
    implements Serializable,
    Cloneable {
        private V value;
        private long access;

        private Value(V value) {
            this.value = value;
            this.updateAccessTime();
        }

        private final void updateAccessTime() {
            this.access = System.currentTimeMillis();
        }

        public final V getValue() {
            return this.value;
        }

        public final long getAccessTime() {
            return this.access;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public final String toString() {
            return "(" + this.value + '@' + this.access + ')';
        }
    }

    private static class X {
        private X() {
        }
    }
}

