/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.sys.debugger;

import org.zkoss.bind.sys.debugger.BindingAnnotationInfoChecker;
import org.zkoss.bind.sys.debugger.BindingExecutionInfoCollector;
import org.zkoss.bind.sys.debugger.impl.DefaultDebuggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.UiException;

public abstract class DebuggerFactory {
    private static DebuggerFactory _factory;
    private static boolean _instanceSet;
    public static final String ENABLE_PROP = "org.zkoss.bind.DebuggerFactory.enable";
    public static final String FACTORY_CLASS_PROP = "org.zkoss.bind.DebuggerFactory.class";

    public abstract BindingExecutionInfoCollector getExecutionInfoCollector();

    public abstract BindingAnnotationInfoChecker getAnnotationInfoChecker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DebuggerFactory getInstance() {
        if (_instanceSet) {
            return _factory;
        }
        Class<DebuggerFactory> clazz = DebuggerFactory.class;
        synchronized (DebuggerFactory.class) {
            if (_instanceSet) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return _factory;
            }
            _instanceSet = true;
            if ("true".equalsIgnoreCase(Library.getProperty((String)ENABLE_PROP))) {
                String clz = Library.getProperty((String)FACTORY_CLASS_PROP);
                if (!Strings.isEmpty((String)clz)) {
                    try {
                        _factory = (DebuggerFactory)Classes.forNameByThread((String)clz).newInstance();
                    }
                    catch (Exception e) {
                        throw new UiException(e.getMessage(), (Throwable)e);
                    }
                } else {
                    _factory = new DefaultDebuggerFactory();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _factory;
        }
    }
}

