/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import junitparams.FileParameters;
import junitparams.Parameters;
import junitparams.internal.Utils;
import junitparams.internal.parameters.ParametersReader;
import junitparams.naming.MacroSubstitutionNamingStrategy;
import junitparams.naming.TestCaseNamingStrategy;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class TestMethod {
    private FrameworkMethod frameworkMethod;
    private Class<?> testClass;
    private ParametersReader parametersReader;
    private Object[] cachedParameters;
    private TestCaseNamingStrategy namingStrategy;

    public TestMethod(FrameworkMethod method, TestClass testClass) {
        this.frameworkMethod = method;
        this.testClass = testClass.getJavaClass();
        this.parametersReader = new ParametersReader(this.testClass(), this.frameworkMethod);
        this.namingStrategy = new MacroSubstitutionNamingStrategy(this);
    }

    public String name() {
        return this.frameworkMethod.getName();
    }

    public static List<TestMethod> listFrom(List<FrameworkMethod> annotatedMethods, TestClass testClass) {
        ArrayList<TestMethod> methods = new ArrayList<TestMethod>();
        for (FrameworkMethod frameworkMethod : annotatedMethods) {
            methods.add(new TestMethod(frameworkMethod, testClass));
        }
        return methods;
    }

    public int hashCode() {
        return this.frameworkMethod.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TestMethod)) {
            return false;
        }
        if (!this.frameworkMethod.getName().equals(((TestMethod)obj).frameworkMethod.getName())) {
            return false;
        }
        return this.frameworkMethod.getMethod().getParameterTypes().equals(((TestMethod)obj).frameworkMethod.getMethod().getParameterTypes());
    }

    Class<?> testClass() {
        return this.testClass;
    }

    public boolean isIgnored() {
        if (this.frameworkMethod.getAnnotation(Ignore.class) != null) {
            return true;
        }
        return this.isParameterised() && this.parametersSets().length == 0;
    }

    public boolean isNotIgnored() {
        return !this.isIgnored();
    }

    public Annotation[] annotations() {
        return this.frameworkMethod.getAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<? extends Annotation> annotationType) {
        return (T)this.frameworkMethod.getAnnotation(annotationType);
    }

    Description describe() {
        if (this.isNotIgnored() && !this.describeFlat()) {
            Description parametrised = Description.createSuiteDescription((String)this.name(), (Annotation[])new Annotation[0]);
            Object[] params = this.parametersSets();
            for (int i = 0; i < params.length; ++i) {
                Object paramSet = params[i];
                String name = this.namingStrategy.getTestCaseName(i, paramSet);
                String uniqueMethodId = Utils.uniqueMethodId(i, paramSet, this.name());
                parametrised.addChild(Description.createTestDescription((String)this.testClass().getName(), (String)name, (Serializable)((Object)uniqueMethodId)));
            }
            return parametrised;
        }
        return Description.createTestDescription(this.testClass(), (String)this.name(), (Annotation[])this.annotations());
    }

    private boolean describeFlat() {
        return System.getProperty("JUnitParams.flat") != null;
    }

    public Object[] parametersSets() {
        if (this.cachedParameters == null) {
            this.cachedParameters = this.parametersReader.read();
        }
        return this.cachedParameters;
    }

    public boolean isParameterised() {
        return this.frameworkMethod.getMethod().isAnnotationPresent(Parameters.class) || this.frameworkMethod.getMethod().isAnnotationPresent(FileParameters.class);
    }

    void warnIfNoParamsGiven() {
        if (this.isNotIgnored() && this.isParameterised() && this.parametersSets().length == 0) {
            System.err.println("Method " + this.name() + " gets empty list of parameters, so it's being ignored!");
        }
    }

    public FrameworkMethod frameworkMethod() {
        return this.frameworkMethod;
    }
}

