/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junitparams.internal.Memoizer;
import junitparams.internal.ParametrizedDescription;
import junitparams.internal.annotation.FrameworkMethodAnnotations;
import junitparams.internal.parameters.ParametersReader;
import junitparams.naming.MacroSubstitutionNamingStrategy;
import junitparams.naming.TestCaseName;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class TestMethod {
    private FrameworkMethod frameworkMethod;
    private FrameworkMethodAnnotations frameworkMethodAnnotations;
    private Memoizer<Object[]> parameters;
    private Memoizer<Description> description;

    public TestMethod(FrameworkMethod method, final TestClass testClass) {
        this.frameworkMethod = method;
        this.frameworkMethodAnnotations = new FrameworkMethodAnnotations(method);
        this.description = new Memoizer<Description>(){

            @Override
            protected Description computeValue() {
                if (TestMethod.this.isNotIgnored() && !this.describeFlat()) {
                    MacroSubstitutionNamingStrategy namingStrategy = new MacroSubstitutionNamingStrategy(TestMethod.this.getAnnotation(TestCaseName.class), TestMethod.this.name());
                    return new ParametrizedDescription(namingStrategy, testClass.getJavaClass().getName(), TestMethod.this.name()).parametrizedDescription(TestMethod.this.parametersSets());
                }
                return Description.createTestDescription((Class)testClass.getJavaClass(), (String)TestMethod.this.name(), (Annotation[])TestMethod.this.frameworkMethodAnnotations.allAnnotations());
            }

            private boolean describeFlat() {
                return System.getProperty("JUnitParams.flat") != null;
            }
        };
        this.parameters = new Memoizer<Object[]>(){

            @Override
            protected Object[] computeValue() {
                return new ParametersReader(testClass.getJavaClass(), TestMethod.this.frameworkMethod).read();
            }
        };
    }

    public String name() {
        return this.frameworkMethod.getName();
    }

    static List<TestMethod> listFrom(List<FrameworkMethod> annotatedMethods, TestClass testClass) {
        ArrayList<TestMethod> methods = new ArrayList<TestMethod>();
        for (FrameworkMethod frameworkMethod : annotatedMethods) {
            methods.add(new TestMethod(frameworkMethod, testClass));
        }
        return methods;
    }

    public int hashCode() {
        return this.frameworkMethod.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TestMethod && this.hasTheSameNameAsFrameworkMethod((TestMethod)obj) && this.hasTheSameParameterTypesAsFrameworkMethod((TestMethod)obj);
    }

    private boolean hasTheSameNameAsFrameworkMethod(TestMethod testMethod) {
        return this.frameworkMethod.getName().equals(testMethod.frameworkMethod.getName());
    }

    private boolean hasTheSameParameterTypesAsFrameworkMethod(TestMethod testMethod) {
        Object[] frameworkMethodParameterTypes = this.frameworkMethod.getMethod().getParameterTypes();
        Object[] testMethodParameterTypes = testMethod.frameworkMethod.getMethod().getParameterTypes();
        return Arrays.equals(frameworkMethodParameterTypes, testMethodParameterTypes);
    }

    public boolean isIgnored() {
        return this.hasIgnoredAnnotation() || this.hasNoParameters();
    }

    private boolean hasIgnoredAnnotation() {
        return this.frameworkMethodAnnotations.hasAnnotation(Ignore.class);
    }

    private boolean hasNoParameters() {
        return this.isParameterised() && this.parametersSets().length == 0;
    }

    public boolean isNotIgnored() {
        return !this.isIgnored();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.frameworkMethodAnnotations.getAnnotation(annotationType);
    }

    Description describe() {
        return this.description.get();
    }

    public Object[] parametersSets() {
        return this.parameters.get();
    }

    void warnIfNoParamsGiven() {
        if (this.isNotIgnored() && this.isParameterised() && this.parametersSets().length == 0) {
            System.err.println("Method " + this.name() + " gets empty list of parameters, so it's being ignored!");
        }
    }

    public FrameworkMethod frameworkMethod() {
        return this.frameworkMethod;
    }

    boolean isParameterised() {
        return this.frameworkMethodAnnotations.isParametrised();
    }
}

