/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal.parameters.toarray;

import java.util.ArrayList;
import junitparams.internal.parameters.toarray.ResultToArray;

class SimpleIterableResultToArray
implements ResultToArray {
    private final Object result;

    SimpleIterableResultToArray(Object result) {
        this.result = result;
    }

    @Override
    public boolean isApplicable() {
        return Iterable.class.isAssignableFrom(this.result.getClass());
    }

    @Override
    public Object[] convert() {
        try {
            ArrayList<Object[]> res = new ArrayList<Object[]>();
            for (Object[] paramSet : (Iterable)this.result) {
                res.add(paramSet);
            }
            return res.toArray();
        }
        catch (ClassCastException e1) {
            ArrayList<Object[]> res = new ArrayList<Object[]>();
            for (Object param : (Iterable)this.result) {
                res.add(new Object[]{param});
            }
            return res.toArray();
        }
    }
}

