/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junitparams.internal.InvokeParameterisedMethod;
import junitparams.internal.ParameterisedTestMethodRunner;
import junitparams.internal.TestMethod;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class ParameterisedTestClassRunner {
    private Map<TestMethod, ParameterisedTestMethodRunner> parameterisedMethods = new HashMap<TestMethod, ParameterisedTestMethodRunner>();
    private Map<FrameworkMethod, TestMethod> testMethods = new HashMap<FrameworkMethod, TestMethod>();
    private List<TestMethod> testMethodsList;

    public ParameterisedTestClassRunner(TestClass testClass) {
        this.computeTestMethods(testClass);
        this.fillTestMethodsMap();
        this.computeFrameworkMethods();
    }

    private void computeTestMethods(TestClass testClass) {
        this.testMethodsList = TestMethod.listFrom(testClass.getAnnotatedMethods(Test.class), testClass);
    }

    private void fillTestMethodsMap() {
        for (TestMethod testMethod : this.testMethodsList) {
            this.testMethods.put(testMethod.frameworkMethod(), testMethod);
        }
    }

    public List<FrameworkMethod> computeFrameworkMethods() {
        ArrayList<FrameworkMethod> resultMethods = new ArrayList<FrameworkMethod>();
        for (TestMethod testMethod : this.testMethodsList) {
            if (testMethod.isParameterised()) {
                this.addTestMethodForEachParamSet(resultMethods, testMethod);
                continue;
            }
            this.addTestMethodOnce(resultMethods, testMethod);
        }
        return resultMethods;
    }

    public List<FrameworkMethod> returnListOfMethods() {
        ArrayList<FrameworkMethod> resultMethods = new ArrayList<FrameworkMethod>();
        for (TestMethod testMethod : this.testMethodsList) {
            this.addTestMethodOnce(resultMethods, testMethod);
            this.cacheMethodRunner(testMethod);
            testMethod.warnIfNoParamsGiven();
        }
        return resultMethods;
    }

    private void addTestMethodForEachParamSet(List<FrameworkMethod> resultMethods, TestMethod testMethod) {
        if (testMethod.isNotIgnored()) {
            int paramSetSize = testMethod.parametersSets().length;
            for (int i = 0; i < paramSetSize; ++i) {
                this.addTestMethodOnce(resultMethods, testMethod);
            }
        } else {
            this.addTestMethodOnce(resultMethods, testMethod);
        }
    }

    private void addTestMethodOnce(List<FrameworkMethod> resultMethods, TestMethod testMethod) {
        resultMethods.add(testMethod.frameworkMethod());
    }

    private void cacheMethodRunner(TestMethod testMethod) {
        if (!this.parameterisedMethods.containsKey(testMethod)) {
            this.parameterisedMethods.put(testMethod, new ParameterisedTestMethodRunner(testMethod));
        }
    }

    public Statement parameterisedMethodInvoker(FrameworkMethod method, Object testClass) {
        TestMethod testMethod = this.testMethods.get(method);
        if (!testMethod.isParameterised()) {
            return null;
        }
        return this.buildMethodInvoker(method, testClass, testMethod);
    }

    private Statement buildMethodInvoker(FrameworkMethod method, Object testClass, TestMethod testMethod) {
        ParameterisedTestMethodRunner parameterisedMethod = this.parameterisedMethods.get(testMethod);
        return new InvokeParameterisedMethod(method, testClass, parameterisedMethod.currentParamsFromAnnotation(), parameterisedMethod.count());
    }

    public boolean shouldRun(TestMethod testMethod) {
        return testMethod.isParameterised();
    }

    public void runParameterisedTest(TestMethod method, Statement methodInvoker, RunNotifier notifier) {
        this.parameterisedMethods.get(method).runTestMethod(methodInvoker, notifier);
    }

    public Description describeParameterisedMethod(FrameworkMethod method) {
        TestMethod testMethod = this.testMethods.get(method);
        if (!testMethod.isParameterised()) {
            return null;
        }
        return testMethod.description();
    }

    public TestMethod testMethodFor(FrameworkMethod method) {
        return this.testMethods.get(method);
    }

    public Description getDescriptionFor(FrameworkMethod method) {
        TestMethod testMethod = this.testMethodFor(method);
        if (this.shouldRun(testMethod)) {
            ParameterisedTestMethodRunner runner = this.parameterisedMethods.get(testMethod);
            return this.wasInvoked(runner) ? runner.currentTestDescription() : null;
        }
        return null;
    }

    private boolean wasInvoked(ParameterisedTestMethodRunner runner) {
        return runner != null && runner.count() != 0;
    }
}

