/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal.parameters.toarray;

import java.util.Arrays;
import java.util.List;
import junitparams.internal.parameters.toarray.IterableResultToArray;
import junitparams.internal.parameters.toarray.IteratorResultToArray;
import junitparams.internal.parameters.toarray.ObjectArrayResultToArray;
import junitparams.internal.parameters.toarray.ResultToArray;
import junitparams.internal.parameters.toarray.SimpleIterableResultToArray;
import org.junit.runners.model.FrameworkMethod;

public class ParamsToArrayConverter {
    private FrameworkMethod frameworkMethod;

    public ParamsToArrayConverter(FrameworkMethod frameworkMethod) {
        this.frameworkMethod = frameworkMethod;
    }

    public Object[] convert(Object result) {
        SimpleIterableResultToArray converter;
        Class<?> type;
        if (this.frameworkMethod.getMethod().getParameterTypes().length == 1 && (type = this.frameworkMethod.getMethod().getParameterTypes()[0]).isAssignableFrom(result.getClass()) && (converter = new SimpleIterableResultToArray(result)).isApplicable()) {
            return converter.convert();
        }
        List<ResultToArray> converters = Arrays.asList(new ObjectArrayResultToArray(result, this.frameworkMethod), new IterableResultToArray(result), new IteratorResultToArray(result));
        for (ResultToArray converter2 : converters) {
            if (!converter2.isApplicable()) continue;
            return converter2.convert();
        }
        throw new ClassCastException();
    }
}

