/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core;

import com.google.common.base.Strings;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import pl.project13.core.AheadBehind;
import pl.project13.core.CommitIdGenerationMode;
import pl.project13.core.GitCommitIdExecutionException;
import pl.project13.core.GitProvider;
import pl.project13.core.PropertiesFilterer;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.cibuild.UnknownBuildServerData;
import pl.project13.core.git.GitDescribeConfig;
import pl.project13.core.log.LoggerBridge;
import pl.project13.core.util.PropertyManager;

public abstract class GitDataProvider
implements GitProvider {
    @Nonnull
    protected final LoggerBridge log;
    protected String prefixDot;
    protected int abbrevLength;
    protected String dateFormat;
    protected String dateFormatTimeZone;
    protected GitDescribeConfig gitDescribe = new GitDescribeConfig();
    protected CommitIdGenerationMode commitIdGenerationMode;
    protected String evaluateOnCommit;
    protected boolean useBranchNameFromBuildEnvironment;
    protected List<String> excludeProperties;
    protected List<String> includeOnlyProperties;
    protected boolean offline;
    static final Pattern GIT_SCP_FORMAT = Pattern.compile("^([a-zA-Z0-9_.+-])+@(.*)|^\\[([^\\]])+\\]:(.*)|^file:/{2,3}(.*)");

    public GitDataProvider(@Nonnull LoggerBridge log) {
        this.log = log;
    }

    public GitDataProvider setGitDescribe(GitDescribeConfig gitDescribe) {
        this.gitDescribe = gitDescribe;
        return this;
    }

    public GitDataProvider setPrefixDot(String prefixDot) {
        this.prefixDot = prefixDot;
        return this;
    }

    public GitDataProvider setAbbrevLength(int abbrevLength) {
        this.abbrevLength = abbrevLength;
        return this;
    }

    public GitDataProvider setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public GitDataProvider setCommitIdGenerationMode(CommitIdGenerationMode commitIdGenerationMode) {
        this.commitIdGenerationMode = commitIdGenerationMode;
        return this;
    }

    public GitDataProvider setDateFormatTimeZone(String dateFormatTimeZone) {
        this.dateFormatTimeZone = dateFormatTimeZone;
        return this;
    }

    public GitDataProvider setUseBranchNameFromBuildEnvironment(boolean useBranchNameFromBuildEnvironment) {
        this.useBranchNameFromBuildEnvironment = useBranchNameFromBuildEnvironment;
        return this;
    }

    public GitDataProvider setExcludeProperties(List<String> excludeProperties) {
        this.excludeProperties = excludeProperties;
        return this;
    }

    public GitDataProvider setIncludeOnlyProperties(List<String> includeOnlyProperties) {
        this.includeOnlyProperties = includeOnlyProperties;
        return this;
    }

    public GitDataProvider setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGitData(@Nonnull String evaluateOnCommit, @Nonnull Properties properties) throws GitCommitIdExecutionException {
        this.evaluateOnCommit = evaluateOnCommit;
        this.init();
        this.maybePut(properties, "build.user.name", this::getBuildAuthorName);
        this.maybePut(properties, "build.user.email", this::getBuildAuthorEmail);
        try {
            this.prepareGitToExtractMoreDetailedRepoInformation();
            this.validateAbbrevLength(this.abbrevLength);
            this.maybePut(properties, "branch", () -> this.determineBranchName(System.getenv()));
            this.maybePutGitDescribe(properties);
            this.loadShortDescribe(properties);
            switch (this.commitIdGenerationMode) {
                case FULL: {
                    this.maybePut(properties, "commit.id.full", this::getCommitId);
                    break;
                }
                case FLAT: {
                    this.maybePut(properties, "commit.id", this::getCommitId);
                    break;
                }
                default: {
                    throw new GitCommitIdExecutionException("Unsupported commitIdGenerationMode: " + (Object)((Object)this.commitIdGenerationMode));
                }
            }
            this.maybePut(properties, "commit.id.abbrev", this::getAbbrevCommitId);
            this.maybePut(properties, "dirty", () -> Boolean.toString(this.isDirty()));
            this.maybePut(properties, "commit.user.name", this::getCommitAuthorName);
            this.maybePut(properties, "commit.user.email", this::getCommitAuthorEmail);
            this.maybePut(properties, "commit.message.full", this::getCommitMessageFull);
            this.maybePut(properties, "commit.message.short", this::getCommitMessageShort);
            this.maybePut(properties, "commit.time", this::getCommitTime);
            this.maybePut(properties, "remote.origin.url", this::getRemoteOriginUrl);
            this.maybePut(properties, "tags", this::getTags);
            this.maybePut(properties, "closest.tag.name", this::getClosestTagName);
            this.maybePut(properties, "closest.tag.commit.count", this::getClosestTagCommitCount);
            this.maybePut(properties, "total.commit.count", this::getTotalCommitCount);
            SupplierEx<AheadBehind> aheadBehindSupplier = GitDataProvider.memoize(this::getAheadBehind);
            this.maybePut(properties, "local.branch.ahead", () -> ((AheadBehind)aheadBehindSupplier.get()).ahead());
            this.maybePut(properties, "local.branch.behind", () -> ((AheadBehind)aheadBehindSupplier.get()).behind());
        }
        finally {
            this.finalCleanUp();
        }
    }

    private void maybePutGitDescribe(@Nonnull Properties properties) throws GitCommitIdExecutionException {
        boolean isGitDescribeOptOutByConfiguration;
        boolean isGitDescribeOptOutByDefault = this.gitDescribe == null;
        boolean bl = isGitDescribeOptOutByConfiguration = this.gitDescribe != null && !this.gitDescribe.isSkip();
        if (isGitDescribeOptOutByDefault || isGitDescribeOptOutByConfiguration) {
            this.maybePut(properties, "commit.id.describe", this::getGitDescribe);
        }
    }

    protected void loadShortDescribe(@Nonnull Properties properties) throws GitCommitIdExecutionException {
        String commitDescribe = properties.getProperty(this.prefixDot + "commit.id.describe");
        if (commitDescribe != null) {
            int startPos = commitDescribe.indexOf("-g");
            if (startPos > 0) {
                int endPos = commitDescribe.indexOf(45, startPos + 1);
                String commitShortDescribe = endPos < 0 ? commitDescribe.substring(0, startPos) : commitDescribe.substring(0, startPos) + commitDescribe.substring(endPos);
                this.maybePut(properties, "commit.id.describe-short", () -> commitShortDescribe);
            } else {
                this.maybePut(properties, "commit.id.describe-short", () -> commitDescribe);
            }
        }
    }

    void validateAbbrevLength(int abbrevLength) throws GitCommitIdExecutionException {
        if (abbrevLength < 2 || abbrevLength > 40) {
            throw new GitCommitIdExecutionException(String.format("Abbreviated commit id length must be between 2 and 40, inclusive! Was [%s]. ", abbrevLength) + "Please fix your configuration (the <abbrevLength/> element).");
        }
    }

    protected String determineBranchName(@Nonnull Map<String, String> env) throws GitCommitIdExecutionException {
        BuildServerDataProvider buildServerDataProvider = BuildServerDataProvider.getBuildServerProvider(env, this.log);
        if (this.useBranchNameFromBuildEnvironment && !(buildServerDataProvider instanceof UnknownBuildServerData)) {
            String branchName = buildServerDataProvider.getBuildBranch();
            if (Strings.isNullOrEmpty((String)branchName)) {
                this.log.info("Detected that running on CI environment, but using repository branch, no GIT_BRANCH detected.");
                return this.getBranchName();
            }
            return branchName;
        }
        return this.getBranchName();
    }

    protected SimpleDateFormat getSimpleDateFormatWithTimeZone() {
        SimpleDateFormat smf = new SimpleDateFormat(this.dateFormat);
        if (this.dateFormatTimeZone != null) {
            smf.setTimeZone(TimeZone.getTimeZone(this.dateFormatTimeZone));
        }
        return smf;
    }

    protected void maybePut(@Nonnull Properties properties, String key, SupplierEx<String> value) throws GitCommitIdExecutionException {
        String keyWithPrefix = this.prefixDot + key;
        if (properties.containsKey(keyWithPrefix)) {
            String propertyValue = properties.getProperty(keyWithPrefix);
            this.log.info("Using cached {} with value {}", (Object)keyWithPrefix, (Object)propertyValue);
        } else if (PropertiesFilterer.isIncluded(keyWithPrefix, this.includeOnlyProperties, this.excludeProperties)) {
            String propertyValue = value.get();
            this.log.info("Collected {} with value {}", (Object)keyWithPrefix, (Object)propertyValue);
            PropertyManager.putWithoutPrefix(properties, keyWithPrefix, propertyValue);
        }
    }

    public static <T> SupplierEx<T> memoize(SupplierEx<T> delegate) {
        AtomicBoolean retrived = new AtomicBoolean(false);
        AtomicReference value = new AtomicReference();
        return () -> {
            if (!retrived.get()) {
                value.set(delegate.get());
                retrived.set(true);
            }
            return value.get();
        };
    }

    protected String stripCredentialsFromOriginUrl(String gitRemoteString) throws GitCommitIdExecutionException {
        if (gitRemoteString == null) {
            return gitRemoteString;
        }
        if (GIT_SCP_FORMAT.matcher(gitRemoteString).matches()) {
            return gitRemoteString;
        }
        try {
            URI original = new URI(gitRemoteString);
            String userInfoString = original.getUserInfo();
            if (null == userInfoString) {
                return gitRemoteString;
            }
            String[] userInfo = userInfoString.split(":");
            return new URI(original.getScheme(), userInfo[0], original.getHost(), original.getPort(), original.getPath(), original.getQuery(), original.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            this.log.error("Something went wrong to strip the credentials from git's remote url (please report this)!", e);
            return "";
        }
    }

    @FunctionalInterface
    public static interface SupplierEx<T> {
        @CanIgnoreReturnValue
        public T get() throws GitCommitIdExecutionException;
    }
}

