/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.log;

import org.apache.maven.plugin.Mojo;
import pl.project13.core.log.FormattingTuple;
import pl.project13.core.log.LoggerBridge;
import pl.project13.core.log.MessageFormatter;

public class MavenLoggerBridge
implements LoggerBridge {
    private boolean verbose;
    private final Mojo mojo;

    public MavenLoggerBridge(Mojo mojo, boolean verbose) {
        this.mojo = mojo;
        this.verbose = verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDebugEnabled() {
        return this.mojo.getLog().isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.mojo.getLog().isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.mojo.getLog().isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.mojo.getLog().isErrorEnabled();
    }

    public void debug(String msg) {
        if (this.verbose) {
            this.mojo.getLog().debug((CharSequence)msg);
        }
    }

    public void debug(String format, Object arg) {
        if (this.verbose) {
            this.debug(MessageFormatter.format((String)format, (Object)arg));
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.verbose) {
            this.debug(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.verbose) {
            this.debug(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.verbose) {
            this.mojo.getLog().debug((CharSequence)msg, t);
        }
    }

    public void info(String msg) {
        if (this.verbose) {
            this.mojo.getLog().info((CharSequence)msg);
        }
    }

    public void info(String format, Object arg) {
        if (this.verbose) {
            this.info(MessageFormatter.format((String)format, (Object)arg));
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.verbose) {
            this.info(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.verbose) {
            this.info(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
        }
    }

    public void info(String msg, Throwable t) {
        if (this.verbose) {
            this.mojo.getLog().info((CharSequence)msg, t);
        }
    }

    public void warn(String msg) {
        if (this.verbose) {
            this.mojo.getLog().warn((CharSequence)msg);
        }
    }

    public void warn(String format, Object arg) {
        if (this.verbose) {
            this.warn(MessageFormatter.format((String)format, (Object)arg));
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.verbose) {
            this.warn(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.verbose) {
            this.warn(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.verbose) {
            this.mojo.getLog().warn((CharSequence)msg, t);
        }
    }

    public void error(String msg) {
        if (this.verbose) {
            this.mojo.getLog().error((CharSequence)msg);
        }
    }

    public void error(String format, Object arg) {
        if (this.verbose) {
            this.error(MessageFormatter.format((String)format, (Object)arg));
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.verbose) {
            this.error(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.verbose) {
            this.error(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
        }
    }

    public void error(String msg, Throwable t) {
        if (this.verbose) {
            this.mojo.getLog().error((CharSequence)msg, t);
        }
    }

    private void debug(FormattingTuple tuple) {
        if (null == tuple.getThrowable()) {
            this.mojo.getLog().debug((CharSequence)tuple.getMessage());
        } else {
            this.mojo.getLog().debug((CharSequence)tuple.getMessage(), tuple.getThrowable());
        }
    }

    private void info(FormattingTuple tuple) {
        if (null == tuple.getThrowable()) {
            this.mojo.getLog().info((CharSequence)tuple.getMessage());
        } else {
            this.mojo.getLog().info((CharSequence)tuple.getMessage(), tuple.getThrowable());
        }
    }

    private void warn(FormattingTuple tuple) {
        if (null == tuple.getThrowable()) {
            this.mojo.getLog().warn((CharSequence)tuple.getMessage());
        } else {
            this.mojo.getLog().warn((CharSequence)tuple.getMessage(), tuple.getThrowable());
        }
    }

    private void error(FormattingTuple tuple) {
        if (null == tuple.getThrowable()) {
            this.mojo.getLog().error((CharSequence)tuple.getMessage());
        } else {
            this.mojo.getLog().error((CharSequence)tuple.getMessage(), tuple.getThrowable());
        }
    }
}

