/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;

public class LabelSerializer {
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
    private int cursor;
    private int labelsCount;
    private int lastSizePosition;

    public void clear() {
        this.cursor = 0;
        this.labelsCount = 0;
    }

    public int sizeBytes() {
        return this.cursor;
    }

    public int getLabelsCount() {
        return this.labelsCount;
    }

    public LabelSerializer appendLabelName(String key) {
        this.cursor += this.buffer.putStringAscii(this.cursor, key);
        ++this.labelsCount;
        return this;
    }

    public LabelSerializer startAppendingLabelValue() {
        this.lastSizePosition = this.cursor;
        this.cursor += 4;
        return this;
    }

    public LabelSerializer appendPartialLabelValue(CharSequence value) {
        this.cursor += this.buffer.putStringWithoutLengthAscii(this.cursor, value);
        return this;
    }

    public LabelSerializer finishAppendingLabelValue() {
        this.buffer.putInt(this.lastSizePosition, this.cursor - this.lastSizePosition - 4);
        return this;
    }

    public LabelSerializer appendLabel(String key, String value) {
        this.appendLabelName(key);
        this.startAppendingLabelValue();
        this.appendPartialLabelValue(value);
        this.finishAppendingLabelValue();
        return this;
    }

    public DirectBuffer getBuffer() {
        return this.buffer;
    }

    public boolean equals(Object o) {
        if (o instanceof LabelSerializer) {
            LabelSerializer that = (LabelSerializer)o;
            if (this.cursor != that.cursor) {
                return false;
            }
            byte[] thisArray = this.buffer.byteArray();
            byte[] thatArray = that.buffer.byteArray();
            for (int i = 0; i < this.cursor; ++i) {
                if (thisArray[i] == thatArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int index = 0; index < this.cursor; index += this.buffer.getStringAscii(index, (Appendable)result) + 4) {
        }
        return result.toString();
    }
}

