/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import java.time.Clock;
import pl.tkowalcz.tjahzi.OutputBuffer;

public class TimeCappedBatchingStrategy {
    private final Clock clock;
    private final OutputBuffer outputBuffer;
    private final long batchSize;
    private final long batchWaitMillis;
    private final long shutdownTimeoutMillis;
    private long timeoutDeadline;
    private long shutdownDeadline;

    public TimeCappedBatchingStrategy(Clock clock, OutputBuffer outputBuffer, long batchSize, long batchWaitMillis, long shutdownTimeoutMillis) {
        this.clock = clock;
        this.outputBuffer = outputBuffer;
        this.batchSize = batchSize;
        this.batchWaitMillis = batchWaitMillis;
        this.shutdownTimeoutMillis = shutdownTimeoutMillis;
        this.timeoutDeadline = clock.millis() + batchWaitMillis;
    }

    public boolean shouldProceed() {
        boolean shouldProceed;
        long currentTimeMillis = this.clock.millis();
        boolean bl = shouldProceed = this.exceededBatchSizeThreshold() || this.exceededWaitTimeThreshold(currentTimeMillis);
        if (shouldProceed) {
            this.timeoutDeadline = currentTimeMillis + this.batchWaitMillis;
        }
        return shouldProceed;
    }

    public boolean shouldContinueShutdown() {
        return this.clock.millis() < this.shutdownDeadline;
    }

    public void initShutdown() {
        this.shutdownDeadline = this.clock.millis() + this.shutdownTimeoutMillis;
    }

    private boolean exceededWaitTimeThreshold(long currentTimeMillis) {
        return currentTimeMillis > this.timeoutDeadline & this.outputBuffer.getBytesPending() > 0;
    }

    private boolean exceededBatchSizeThreshold() {
        return (long)this.outputBuffer.getBytesPending() > this.batchSize;
    }
}

