/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.protobuf;

import io.netty.buffer.ByteBuf;

public class Protobuf {
    public static final int LENGTH_DELIMITED_TYPE = 2;
    public static final int VARINT_TYPE = 0;

    public static void writeSize(ByteBuf target, int messageStartIndex) {
        int messageSize = target.writerIndex() - messageStartIndex - 4;
        target.setInt(messageStartIndex, Protobuf.getFixed32Varint(messageSize));
    }

    public static int getFixed32Varint(int value) {
        int byte1 = value & 0x7F | 0x80;
        int byte2 = value >>> 7 & 0x7F | 0x80;
        int byte3 = value >>> 14 & 0x7F | 0x80;
        int byte4 = value >>> 21 & 0x7F;
        return Protobuf.intFromBytes((byte)byte1, (byte)byte2, (byte)byte3, (byte)byte4);
    }

    public static void writeUnsignedVarint(long value, ByteBuf target) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                target.writeByte((int)value);
                return;
            }
            target.writeByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int intFromBytes(byte byte1, byte byte2, byte byte3, byte byte4) {
        return (byte1 & 0xFF) << 24 | (byte2 & 0xFF) << 16 | (byte3 & 0xFF) << 8 | byte4 & 0xFF;
    }
}

