/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.log4j2.labels;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pl.tkowalcz.tjahzi.log4j2.labels.AggregateLabelPrinter;
import pl.tkowalcz.tjahzi.log4j2.labels.Label;
import pl.tkowalcz.tjahzi.log4j2.labels.LabelPrinter;
import pl.tkowalcz.tjahzi.log4j2.labels.Literal;
import pl.tkowalcz.tjahzi.log4j2.labels.MDCLookup;

public class LabelPrinterFactory {
    private static final Pattern CONTEXT_PATTERN = Pattern.compile("\\$\\{ctx:([^}:]+)(?::-([^}]+))?}");

    public static LabelPrinter parse(Label label) {
        return LabelPrinterFactory.parse(label.getValue());
    }

    public static LabelPrinter parse(String string) {
        Matcher matcher = CONTEXT_PATTERN.matcher(string);
        ArrayList<LabelPrinter> result = new ArrayList<LabelPrinter>();
        int lastAppend = 0;
        while (matcher.find()) {
            int start = lastAppend;
            int end = matcher.start();
            String substring = string.substring(start, end);
            result.add(Literal.of(substring));
            String defaultValue = null;
            if (matcher.groupCount() == 2) {
                defaultValue = matcher.group(2);
            }
            String group = matcher.group(1);
            result.add(MDCLookup.of(group, defaultValue));
            lastAppend = matcher.end();
        }
        String substring = string.substring(lastAppend);
        result.add(Literal.of(substring));
        if (result.size() == 1) {
            return (LabelPrinter)result.get(0);
        }
        return AggregateLabelPrinter.of(result);
    }
}

