/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;
import org.apache.poi.hslf.record.TextHeaderAtom;
import org.apache.poi.util.StringUtil;

public class TextRun {
    private TextHeaderAtom _headerAtom;
    private TextBytesAtom _byteAtom;
    private TextCharsAtom _charAtom;
    private boolean _isUnicode;

    public TextRun(TextHeaderAtom tha, TextCharsAtom tca) {
        this._headerAtom = tha;
        this._charAtom = tca;
        this._isUnicode = true;
    }

    public TextRun(TextHeaderAtom tha, TextBytesAtom tba) {
        this._headerAtom = tha;
        this._byteAtom = tba;
        this._isUnicode = false;
    }

    public String getText() {
        String rawText = this.getRawText();
        String text = rawText.replace('\r', '\n');
        return text;
    }

    public String getRawText() {
        if (this._isUnicode) {
            return this._charAtom.getText();
        }
        return this._byteAtom.getText();
    }

    public void setText(String s) {
        if (s.length() != this.getText().length()) {
            System.err.println("Warning: Your powerpoint file may no longer readable by powerpoint, as the text run has changed size!");
        }
        if (this._isUnicode) {
            this._charAtom.setText(s);
        } else {
            boolean hasMultibyte = StringUtil.hasMultibyte((String)s);
            if (!hasMultibyte) {
                byte[] text = new byte[s.length()];
                StringUtil.putCompressedUnicode((String)s, (byte[])text, (int)0);
                this._byteAtom.setText(text);
            } else {
                throw new RuntimeException("Setting of unicode text is currently only possible for Text Runs that are Unicode in the file, sorry. For now, please convert that text to us-ascii and re-try it");
            }
        }
    }

    public int getRunType() {
        return this._headerAtom.getTextType();
    }

    public void setRunType(int type) {
        this._headerAtom.setTextType(type);
    }
}

