/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordContainer;

public class EscherTextboxWrapper
extends RecordContainer {
    private EscherTextboxRecord _escherRecord;
    private Record[] _children;
    private long _type;

    public EscherTextboxRecord getEscherRecord() {
        return this._escherRecord;
    }

    protected EscherTextboxWrapper(EscherTextboxRecord textbox) {
        this._escherRecord = textbox;
        this._type = this._escherRecord.getRecordId();
        byte[] data = this._escherRecord.getData();
        this._children = Record.findChildRecords(data, 0, data.length);
    }

    public long getRecordType() {
        return this._type;
    }

    public Record[] getChildRecords() {
        return this._children;
    }

    public void writeOut(OutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < this._children.length; ++i) {
            this._children[i].writeOut(baos);
        }
        byte[] data = baos.toByteArray();
        this._escherRecord.setData(data);
    }
}

