/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hslf.record.EscherTextboxWrapper;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.util.LittleEndian;

public class PPDrawing
extends RecordAtom {
    private byte[] _header = new byte[8];
    private long _type;
    private EscherRecord[] childRecords;
    private EscherTextboxWrapper[] textboxWrappers;

    public EscherRecord[] getEscherRecords() {
        return this.childRecords;
    }

    public EscherTextboxWrapper[] getTextboxWrappers() {
        return this.textboxWrappers;
    }

    protected PPDrawing(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._type = LittleEndian.getUShort((byte[])this._header, (int)2);
        byte[] contents = new byte[len];
        System.arraycopy(source, start, contents, 0, len);
        DefaultEscherRecordFactory erf = new DefaultEscherRecordFactory();
        Vector escherChildren = new Vector();
        this.findEscherChildren(erf, contents, 8, len - 8, escherChildren);
        this.childRecords = new EscherRecord[escherChildren.size()];
        for (int i = 0; i < this.childRecords.length; ++i) {
            this.childRecords[i] = (EscherRecord)escherChildren.get(i);
        }
        Vector textboxes = new Vector();
        this.findEscherTextboxRecord(this.childRecords, textboxes);
        this.textboxWrappers = new EscherTextboxWrapper[textboxes.size()];
        for (int i = 0; i < this.textboxWrappers.length; ++i) {
            this.textboxWrappers[i] = (EscherTextboxWrapper)textboxes.get(i);
        }
    }

    private void findEscherChildren(DefaultEscherRecordFactory erf, byte[] source, int startPos, int lenToGo, Vector found) {
        EscherRecord r = erf.createRecord(source, startPos);
        r.fillFields(source, startPos, (EscherRecordFactory)erf);
        found.add(r);
        int size = r.getRecordSize();
        if (size < 8) {
            System.err.println("Hit short DDF record at " + startPos + " - " + size);
        }
        startPos += size;
        if ((lenToGo -= size) >= 8) {
            this.findEscherChildren(erf, source, startPos, lenToGo, found);
        }
    }

    private void findEscherTextboxRecord(EscherRecord[] toSearch, Vector found) {
        for (int i = 0; i < toSearch.length; ++i) {
            if (toSearch[i] instanceof EscherTextboxRecord) {
                EscherTextboxRecord tbr = (EscherTextboxRecord)toSearch[i];
                EscherTextboxWrapper w = new EscherTextboxWrapper(tbr);
                found.add(w);
                continue;
            }
            if (!toSearch[i].isContainerRecord()) continue;
            List childrenL = toSearch[i].getChildRecords();
            EscherRecord[] children = new EscherRecord[childrenL.size()];
            for (int j = 0; j < children.length; ++j) {
                children[j] = (EscherRecord)childrenL.get(j);
            }
            this.findEscherTextboxRecord(children, found);
        }
    }

    public long getRecordType() {
        return this._type;
    }

    public Record[] getChildRecords() {
        return null;
    }

    public void writeOut(OutputStream out) throws IOException {
        for (int i = 0; i < this.textboxWrappers.length; ++i) {
            this.textboxWrappers[i].writeOut(null);
        }
        int newSize = 0;
        for (int i = 0; i < this.childRecords.length; ++i) {
            newSize += this.childRecords[i].getRecordSize();
        }
        LittleEndian.putInt((byte[])this._header, (int)4, (int)newSize);
        out.write(this._header);
        byte[] b = new byte[newSize];
        int done = 0;
        for (int i = 0; i < this.childRecords.length; ++i) {
            int written = this.childRecords[i].serialize(done, b);
            done += written;
        }
        out.write(b);
    }
}

