/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.ObjectPoolHelper;
import ro.isdc.wro.extensions.processor.support.uglify.UglifyJs;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.Destroyable;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ObjectFactory;

@SupportedResourceType(value=ResourceType.JS)
public class BeautifyJsProcessor
implements ResourcePreProcessor,
ResourcePostProcessor,
Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(BeautifyJsProcessor.class);
    public static final String ALIAS_BEAUTIFY = "beautifyJs";
    private final ObjectPoolHelper<UglifyJs> enginePool = new ObjectPoolHelper<UglifyJs>(new ObjectFactory<UglifyJs>(){

        public UglifyJs create() {
            return BeautifyJsProcessor.this.newEngine();
        }
    });

    protected UglifyJs newEngine() {
        return UglifyJs.beautifyJs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        UglifyJs engine = this.enginePool.getObject();
        try {
            String filename = resource == null ? "noName.js" : resource.getUri();
            writer.write(engine.process(filename, content));
        }
        catch (WroRuntimeException e) {
            this.onException(e);
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.warn("Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
        }
        finally {
            reader.close();
            writer.close();
            this.enginePool.returnObject(engine);
        }
    }

    protected void onException(WroRuntimeException e) {
        throw e;
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    public void destroy() throws Exception {
        this.enginePool.destroy();
    }
}

