/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.coffeescript;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.extensions.locator.WebjarUriLocator;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.util.WroUtil;

public class CoffeeScript {
    private static final Logger LOG = LoggerFactory.getLogger(CoffeeScript.class);
    private static final String DEFAULT_COFFE_SCRIPT = "coffee-script.js";
    private String[] options;
    private ScriptableObject scope;
    private WebjarUriLocator webjarLocator;

    private RhinoScriptBuilder initScriptBuilder() {
        try {
            RhinoScriptBuilder builder = null;
            if (this.scope == null) {
                builder = RhinoScriptBuilder.newChain().evaluateChain(this.getCoffeeScriptAsStream(), DEFAULT_COFFE_SCRIPT);
                this.scope = builder.getScope();
            } else {
                builder = RhinoScriptBuilder.newChain(this.scope);
            }
            return builder;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed reading init script", ex);
        }
    }

    protected InputStream getCoffeeScriptAsStream() throws IOException {
        return this.getWebjarLocator().locate(WebjarUriLocator.createUri("coffee-script.min.js"));
    }

    private WebjarUriLocator getWebjarLocator() {
        if (this.webjarLocator == null) {
            this.webjarLocator = new WebjarUriLocator();
        }
        return this.webjarLocator;
    }

    public String compile(String data) {
        RhinoScriptBuilder builder = this.initScriptBuilder();
        String compileScript = String.format("CoffeeScript.compile(%s, %s);", WroUtil.toJSMultiLineString((String)data), this.buildOptions());
        return (String)builder.evaluate(compileScript, "CoffeeScript.compile");
    }

    private String buildOptions() {
        StringBuffer sb = new StringBuffer("{");
        if (this.options != null) {
            for (int i = 0; i < this.options.length; ++i) {
                sb.append(this.options[i]).append(": true");
                if (i >= this.options.length - 1) continue;
                sb.append(",");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public CoffeeScript setOptions(String ... options) {
        this.options = options == null ? new String[]{} : options;
        LOG.debug("setOptions: {}", Arrays.asList(this.options));
        return this;
    }
}

